/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.xmldsig;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.AbstractStaxXmlDSigParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.DsaKeyValueParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.RsaKeyValueParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.X509DataParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.XmlDSigQNames;

public class KeyInfoParser
extends AbstractStaxXmlDSigParser<KeyInfoType> {
    public static final KeyInfoParser INSTANCE = new KeyInfoParser();

    private KeyInfoParser() {
        super(XmlDSigQNames.KEY_INFO);
    }

    public static KeyInfoParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected KeyInfoType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new KeyInfoType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, KeyInfoType target, XmlDSigQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case X509_DATA: {
                target.addContent(X509DataParser.getInstance().parse(xmlEventReader));
                break;
            }
            case KEY_VALUE: {
                KeyValueType keyValue;
                StaxParserUtil.advance(xmlEventReader);
                StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                switch ((XmlDSigQNames)LOOKUP.from(startElement.getName())) {
                    case RSA_KEY_VALUE: {
                        keyValue = (KeyValueType)RsaKeyValueParser.getInstance().parse(xmlEventReader);
                        break;
                    }
                    case DSA_KEY_VALUE: {
                        keyValue = (KeyValueType)DsaKeyValueParser.getInstance().parse(xmlEventReader);
                        break;
                    }
                    default: {
                        String tag = StaxParserUtil.getElementName(startElement);
                        throw LOGGER.parserUnknownTag(tag, elementDetail.getLocation());
                    }
                }
                target.addContent((Object)keyValue);
                break;
            }
            default: {
                StaxParserUtil.bypassElementBlock(xmlEventReader);
            }
        }
    }
}

