/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.core.Column;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_2_6_RemoveDuplicateMigrationModelVersion
extends CustomKeycloakTask {
    private static final String MIGRATION_MODEL_TABLE = "MIGRATION_MODEL";

    @Override
    protected String getTaskId() {
        return "Delete duplicated records for DB version in MIGRATION_MODEL table";
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        HashSet<String> idsToDelete = new HashSet<String>();
        String tableName = this.getTableName(MIGRATION_MODEL_TABLE);
        String colId = this.database.correctObjectName("ID", Column.class);
        String colVersion = this.database.correctObjectName("VERSION", Column.class);
        String colUpdateTime = this.database.correctObjectName("UPDATE_TIME", Column.class);
        try (PreparedStatement ps = this.connection.prepareStatement(this.getOlderDuplicatedRecords(tableName, colId, colVersion, colUpdateTime));){
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                idsToDelete.add(resultSet.getString(1));
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Failed to detect duplicate MIGRATION_MODEL rows", (Throwable)e);
        }
        AtomicInteger i = new AtomicInteger();
        idsToDelete.stream().collect(Collectors.groupingByConcurrent(id -> i.getAndIncrement() / 20, Collectors.toList())).values().stream().map(ids -> new DeleteStatement(null, null, MIGRATION_MODEL_TABLE).setWhere(":name IN (" + ids.stream().map(id -> "?").collect(Collectors.joining(",")) + ")").addWhereColumnName(colId).addWhereParameters(ids.toArray())).forEach(this.statements::add);
    }

    private String getOlderDuplicatedRecords(String tableName, String colId, String colVersion, String colUpdateTime) {
        return "SELECT m1.%s\nFROM %s m1\nWHERE EXISTS (\n    SELECT m2.%s\n    FROM %s m2\n    WHERE m2.%s = m1.%s\n    AND (\n        m2.%s > m1.%s\n        OR (m2.%s = m1.%s AND m2.%s > m1.%s)\n    )\n)\n".formatted(colId, tableName, colId, tableName, colVersion, colVersion, colUpdateTime, colUpdateTime, colUpdateTime, colUpdateTime, colId, colId);
    }
}

