/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.util.Objects;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65598)
@Indexed
public class LoginFailureEntity
extends SessionEntity {
    private final String userId;
    private int failedLoginNotBefore;
    private int numFailures;
    private int numTemporaryLockouts;
    private long lastFailure;
    private String lastIPFailure;

    public LoginFailureEntity(String realmId, String userId) {
        super(Objects.requireNonNull(realmId));
        this.userId = Objects.requireNonNull(userId);
    }

    @ProtoFactory
    LoginFailureEntity(String realmId, String userId, int failedLoginNotBefore, int numFailures, int numTemporaryLockouts, long lastFailure, String lastIPFailure) {
        super(realmId);
        this.userId = userId;
        this.failedLoginNotBefore = failedLoginNotBefore;
        this.numFailures = numFailures;
        this.numTemporaryLockouts = numTemporaryLockouts;
        this.lastFailure = lastFailure;
        this.lastIPFailure = lastIPFailure;
    }

    @ProtoField(value=2)
    public String getUserId() {
        return this.userId;
    }

    @ProtoField(value=3)
    public int getFailedLoginNotBefore() {
        return this.failedLoginNotBefore;
    }

    public void setFailedLoginNotBefore(int failedLoginNotBefore) {
        if (failedLoginNotBefore > this.failedLoginNotBefore) {
            this.failedLoginNotBefore = failedLoginNotBefore;
        }
    }

    @ProtoField(value=4)
    public int getNumFailures() {
        return this.numFailures;
    }

    public void setNumFailures(int numFailures) {
        this.numFailures = numFailures;
    }

    @ProtoField(value=5)
    public int getNumTemporaryLockouts() {
        return this.numTemporaryLockouts;
    }

    public void setNumTemporaryLockouts(int numTemporaryLockouts) {
        this.numTemporaryLockouts = numTemporaryLockouts;
    }

    @ProtoField(value=6)
    public long getLastFailure() {
        return this.lastFailure;
    }

    public void setLastFailure(long lastFailure) {
        if (lastFailure > this.lastFailure) {
            this.lastFailure = lastFailure;
        }
    }

    @ProtoField(value=7)
    public String getLastIPFailure() {
        return this.lastIPFailure;
    }

    public void setLastIPFailure(String lastIPFailure) {
        this.lastIPFailure = lastIPFailure;
    }

    public void clearFailures() {
        this.failedLoginNotBefore = 0;
        this.numFailures = 0;
        this.numTemporaryLockouts = 0;
        this.lastFailure = 0L;
        this.lastIPFailure = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoginFailureEntity)) {
            return false;
        }
        LoginFailureEntity that = (LoginFailureEntity)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.getRealmId(), that.getRealmId());
    }

    @Override
    public int hashCode() {
        int hashCode = this.getRealmId() != null ? this.getRealmId().hashCode() : 0;
        hashCode = hashCode * 13 + (this.userId != null ? this.userId.hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        return String.format("LoginFailureEntity [ userId=%s, realm=%s, numFailures=%d ]", this.userId, this.getRealmId(), this.numFailures);
    }
}

