/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyGenerator;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.PersistentUserSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsWorker;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory<UserSessionProvider>,
ServerInfoAwareProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String REMOVE_USER_SESSIONS_EVENT = "REMOVE_USER_SESSIONS_EVENT";
    public static final String CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineSessionCacheEntryLifespanOverride";
    public static final String CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineClientSessionCacheEntryLifespanOverride";
    public static final String CONFIG_MAX_BATCH_SIZE = "maxBatchSize";
    public static final int DEFAULT_MAX_BATCH_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    public static final String CONFIG_USE_CACHES = "useCaches";
    private static final boolean DEFAULT_USE_CACHES = true;
    public static final String CONFIG_USE_BATCHES = "useBatches";
    private static final boolean DEFAULT_USE_BATCHES = true;
    private long offlineSessionCacheEntryLifespanOverride;
    private long offlineClientSessionCacheEntryLifespanOverride;
    private Config.Scope config;
    private PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    private InfinispanKeyGenerator keyGenerator;
    SerializeExecutionsByKey<String> serializerSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<String> serializerOfflineSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<UUID> serializerClientSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<UUID> serializerOfflineClientSession = new SerializeExecutionsByKey();
    ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate;
    private PersistentSessionsWorker persistentSessionsWorker;
    private int maxBatchSize;
    private boolean useCaches;
    private boolean useBatches;

    public UserSessionProvider create(KeycloakSession session) {
        Cache cache = null;
        Cache offlineSessionsCache = null;
        Cache clientSessionCache = null;
        Cache offlineClientSessionsCache = null;
        if (this.useCaches) {
            InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            cache = connections.getCache("sessions");
            offlineSessionsCache = connections.getCache("offlineSessions");
            clientSessionCache = connections.getCache("clientSessions");
            offlineClientSessionsCache = connections.getCache("offlineClientSessions");
        }
        if (MultiSiteUtils.isPersistentSessionsEnabled()) {
            return new PersistentUserSessionProvider(session, this.keyGenerator, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, this.asyncQueuePersistentUpdate, this.serializerSession, this.serializerOfflineSession, this.serializerClientSession, this.serializerOfflineClientSession);
        }
        return new InfinispanUserSessionProvider(session, this.persisterLastSessionRefreshStore, this.keyGenerator, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, this::deriveOfflineSessionCacheEntryLifespanMs, this::deriveOfflineClientSessionCacheEntryLifespanOverrideMs, this.serializerSession, this.serializerOfflineSession, this.serializerClientSession, this.serializerOfflineClientSession);
    }

    public void init(Config.Scope config) {
        this.config = config;
        this.offlineSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        this.offlineClientSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        this.maxBatchSize = config.getInt(CONFIG_MAX_BATCH_SIZE, Integer.valueOf(DEFAULT_MAX_BATCH_SIZE));
        this.useCaches = config.getBoolean(CONFIG_USE_CACHES, Boolean.valueOf(true)) != false && InfinispanUtils.isEmbeddedInfinispan();
        boolean bl = this.useBatches = config.getBoolean(CONFIG_USE_BATCHES, Boolean.valueOf(true)) != false && MultiSiteUtils.isPersistentSessionsEnabled();
        if (this.useBatches) {
            this.asyncQueuePersistentUpdate = new ArrayBlockingQueue(1000);
        }
    }

    public void postInit(final KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    if (!InfinispanUserSessionProviderFactory.this.useCaches) {
                        InfinispanUserSessionProviderFactory.this.keyGenerator = new InfinispanKeyGenerator(){

                            @Override
                            protected <K> K generateKey(KeycloakSession session, Cache<K, ?> cache, KeyGenerator<K> keyGenerator) {
                                return (K)keyGenerator.getKey();
                            }
                        };
                        return;
                    } else {
                        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> {
                            InfinispanUserSessionProviderFactory.this.keyGenerator = new InfinispanKeyGenerator();
                            if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
                                InfinispanUserSessionProviderFactory.this.initializePersisterLastSessionRefreshStore(factory);
                            }
                            InfinispanUserSessionProviderFactory.this.registerClusterListeners(session);
                        });
                    }
                    return;
                } else if (event instanceof UserModel.UserRemovedEvent) {
                    UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                    UserSessionProvider provider1 = (UserSessionProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionProvider.class, InfinispanUserSessionProviderFactory.this.getId());
                    if (provider1 instanceof InfinispanUserSessionProvider) {
                        ((InfinispanUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                        return;
                    } else {
                        if (!(provider1 instanceof PersistentUserSessionProvider)) throw new IllegalStateException("Unknown provider type: " + String.valueOf(provider1.getClass()));
                        ((PersistentUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                    }
                    return;
                } else {
                    if (!(event instanceof ResetTimeOffsetEvent) || InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore == null) return;
                    InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore.reset();
                }
            }
        });
        if (MultiSiteUtils.isPersistentSessionsEnabled() && this.useBatches) {
            this.persistentSessionsWorker = new PersistentSessionsWorker(factory, this.asyncQueuePersistentUpdate, this.maxBatchSize);
            this.persistentSessionsWorker.start();
        }
    }

    public void initializePersisterLastSessionRefreshStore(KeycloakSessionFactory sessionFactory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore = new PersisterLastSessionRefreshStoreFactory().createAndInit(session, true);
            }
        });
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(REMOVE_USER_SESSIONS_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveUserSessionsEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RemoveUserSessionsEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected Long deriveOfflineSessionCacheEntryLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity entity) {
        long configuredOfflineSessionLifespan = SessionTimeouts.getOfflineSessionLifespanMs(realm, client, entity);
        if (this.offlineSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineSessionLifespan;
        }
        if (configuredOfflineSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride), configuredOfflineSessionLifespan);
    }

    protected Long deriveOfflineClientSessionCacheEntryLifespanOverrideMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity entity) {
        long configuredOfflineClientSessionLifespan = SessionTimeouts.getOfflineClientSessionLifespanMs(realm, client, entity);
        if (this.offlineClientSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineClientSessionLifespan;
        }
        if (configuredOfflineClientSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride), configuredOfflineClientSessionLifespan);
    }

    public void close() {
        if (this.persistentSessionsWorker != null) {
            this.persistentSessionsWorker.stop();
        }
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan() || MultiSiteUtils.isPersistentSessionsEnabled();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineSessionCacheEntryLifespanOverride));
        info.put(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineClientSessionCacheEntryLifespanOverride));
        info.put(CONFIG_MAX_BATCH_SIZE, Integer.toString(this.maxBatchSize));
        info.put(CONFIG_USE_CACHES, Boolean.toString(this.useCaches));
        info.put(CONFIG_USE_BATCHES, Boolean.toString(this.useBatches));
        return info;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(CONFIG_MAX_BATCH_SIZE).type("int").helpText("Maximum size of a batch size (only applicable to persistent sessions").defaultValue((Object)DEFAULT_MAX_BATCH_SIZE).add();
        builder.property().name(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline client sessions should be kept in memory in seconds").add();
        builder.property().name(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline user sessions should be kept in memory in seconds").add();
        builder.property().name(CONFIG_USE_CACHES).type("boolean").helpText("Enable or disable caches. Enabled by default unless the external feature to use only external remote caches is used").add();
        return builder.build();
    }
}

