/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.keycloak.util.JsonSerialization;

public class RealmConfigData {
    private String serverUrl;
    private String realm;
    private String clientId;
    private String token;
    private String refreshToken;
    private String signingToken;
    private String secret;
    private String grantTypeForAuthentication;
    private Long expiresAt;
    private Long refreshExpiresAt;
    private Long sigExpiresAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String initialToken;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> clients = new LinkedHashMap<String, String>();

    public String serverUrl() {
        return this.serverUrl;
    }

    public void serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String realm() {
        return this.realm;
    }

    public void realm(String realm) {
        this.realm = realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getSigningToken() {
        return this.signingToken;
    }

    public void setSigningToken(String signingToken) {
        this.signingToken = signingToken;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getGrantTypeForAuthentication() {
        return this.grantTypeForAuthentication;
    }

    public void setGrantTypeForAuthentication(String grantTypeForAuthentication) {
        this.grantTypeForAuthentication = grantTypeForAuthentication;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Long getRefreshExpiresAt() {
        return this.refreshExpiresAt;
    }

    public void setRefreshExpiresAt(Long refreshExpiresAt) {
        this.refreshExpiresAt = refreshExpiresAt;
    }

    public Long getSigExpiresAt() {
        return this.sigExpiresAt;
    }

    public void setSigExpiresAt(Long sigExpiresAt) {
        this.sigExpiresAt = sigExpiresAt;
    }

    public String getInitialToken() {
        return this.initialToken;
    }

    public void setInitialToken(String initialToken) {
        this.initialToken = initialToken;
    }

    public Map<String, String> getClients() {
        return this.clients;
    }

    public void merge(RealmConfigData source) {
        this.serverUrl = source.serverUrl;
        this.realm = source.realm;
        this.clientId = source.clientId;
        this.token = source.token;
        this.refreshToken = source.refreshToken;
        this.signingToken = source.signingToken;
        this.secret = source.secret;
        this.grantTypeForAuthentication = source.grantTypeForAuthentication;
        this.expiresAt = source.expiresAt;
        this.refreshExpiresAt = source.refreshExpiresAt;
        this.sigExpiresAt = source.sigExpiresAt;
        this.initialToken = source.initialToken;
        this.mergeClients(source);
    }

    private void mergeClients(RealmConfigData source) {
        if (source.clients != null) {
            if (this.clients == null) {
                this.clients = source.clients;
            } else {
                for (String key : source.clients.keySet()) {
                    String val = source.clients.get(key);
                    if (!"".equals(val)) {
                        this.clients.put(key, val);
                        continue;
                    }
                    this.clients.remove(key);
                }
            }
        }
    }

    public void mergeRefreshTokens(RealmConfigData source) {
        this.token = source.token;
        this.refreshToken = source.refreshToken;
        this.expiresAt = source.expiresAt;
        this.refreshExpiresAt = source.refreshExpiresAt;
    }

    public String toString() {
        try {
            return JsonSerialization.writeValueAsPrettyString(this);
        }
        catch (IOException e) {
            return super.toString() + " - Error: " + e.toString();
        }
    }

    public RealmConfigData deepcopy() {
        RealmConfigData data = new RealmConfigData();
        data.serverUrl = this.serverUrl;
        data.realm = this.realm;
        data.clientId = this.clientId;
        data.token = this.token;
        data.refreshToken = this.refreshToken;
        data.signingToken = this.signingToken;
        data.secret = this.secret;
        data.grantTypeForAuthentication = this.grantTypeForAuthentication;
        data.expiresAt = this.expiresAt;
        data.refreshExpiresAt = this.refreshExpiresAt;
        data.sigExpiresAt = this.sigExpiresAt;
        data.initialToken = this.initialToken;
        data.clients = new LinkedHashMap<String, String>(this.clients);
        return data;
    }
}

