/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.devtools.messagewriter.MessageFormatter;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.aether.artifact.Artifact;

public final class QuarkusUpdatesRepository {
    private static final String QUARKUS_UPDATE_RECIPES_GA = "io.quarkus:quarkus-update-recipes";
    private static final Pattern VERSION_EXTRACTION_PATTERN = Pattern.compile("[.][^.]+$");
    public static final String DEFAULT_UPDATE_RECIPES_VERSION = "LATEST";
    public static final String DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION = "4.46.0";
    public static final String DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION = "5.38.0";
    public static final String PROP_REWRITE_MAVEN_PLUGIN_VERSION = "rewrite-maven-plugin-version";
    public static final String PROP_REWRITE_GRADLE_PLUGIN_VERSION = "rewrite-gradle-plugin-version";

    private QuarkusUpdatesRepository() {
    }

    public static FetchResult fetchRecipes(MessageWriter log, MavenArtifactResolver artifactResolver, BuildTool buildTool, String quarkusUpdateRecipes, String additionalUpdateRecipes, String currentVersion, String targetVersion, List<ExtensionUpdateInfo> topExtensionDependency) {
        ArrayList<Object> gavs = new ArrayList<Object>();
        gavs.add(quarkusUpdateRecipes.contains(":") ? quarkusUpdateRecipes : "io.quarkus:quarkus-update-recipes:" + quarkusUpdateRecipes);
        if (additionalUpdateRecipes != null) {
            gavs.addAll(Arrays.stream(additionalUpdateRecipes.split(",")).map(String::strip).toList());
        }
        ArrayList<CallSite> artifacts = new ArrayList<CallSite>();
        ArrayList<String> recipes = new ArrayList<String>();
        String propRewritePluginVersion = null;
        log.info("");
        for (String string : gavs) {
            log.info("Resolving recipes from '%s':", new Object[]{string.replace(":LATEST", "")});
            LinkedHashMap<String, VersionUpdate> recipeDirectoryNames = new LinkedHashMap<String, VersionUpdate>();
            recipeDirectoryNames.put("core", new VersionUpdate(currentVersion, targetVersion));
            for (ExtensionUpdateInfo dep : topExtensionDependency) {
                recipeDirectoryNames.put(QuarkusUpdatesRepository.toKey(dep), new VersionUpdate(dep.getCurrentDep().getVersion(), dep.getRecommendedDependency().getVersion()));
            }
            try {
                Artifact artifact = artifactResolver.resolve(DependencyUtils.toArtifact((String)string)).getArtifact();
                String resolvedGAV = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
                artifacts.add((CallSite)((Object)resolvedGAV));
                ResourceLoader resourceLoader = ResourceLoaders.resolveFileResourceLoader(artifact.getFile());
                List<String> newRecipes = QuarkusUpdatesRepository.fetchUpdateRecipes(log, resourceLoader, "quarkus-updates", recipeDirectoryNames);
                recipes.addAll(newRecipes);
                Properties props = resourceLoader.loadResourceAsPath("quarkus-updates/", p -> {
                    Properties properties = new Properties();
                    Path propPath = p.resolve("recipes.properties");
                    if (Files.isRegularFile(propPath, new LinkOption[0])) {
                        try (InputStream inStream = Files.newInputStream(propPath, new OpenOption[0]);){
                            properties.load(inStream);
                        }
                    }
                    return properties;
                });
                String pluginVersion = QuarkusUpdatesRepository.getPropRewritePluginVersion(props, buildTool);
                if (propRewritePluginVersion == null) {
                    propRewritePluginVersion = pluginVersion;
                } else if (!propRewritePluginVersion.equals(pluginVersion)) {
                    throw new RuntimeException("quarkus update artifacts require multiple rewrite plugin versions: " + propRewritePluginVersion + " and " + pluginVersion);
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("=> %d specific recipe" + (recipes.size() != 1 ? "s" : "") + " found (compatible with OpenRewrite %s plugin version: %s)", new Object[]{recipes.size(), buildTool, propRewritePluginVersion}));
                    continue;
                }
                log.info(String.format("=> %s specific recipe" + (recipes.size() != 1 ? "s" : "") + " found", MessageFormatter.green((String)String.valueOf(recipes.size()))));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve artifact: " + string, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load recipes in artifact: " + string, e);
            }
        }
        return new FetchResult(String.join((CharSequence)",", artifacts), recipes, propRewritePluginVersion);
    }

    private static String getPropRewritePluginVersion(Properties props, BuildTool buildTool) {
        switch (buildTool) {
            case MAVEN: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_MAVEN_PLUGIN_VERSION)).orElse(DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION);
            }
            case GRADLE: 
            case GRADLE_KOTLIN_DSL: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_GRADLE_PLUGIN_VERSION)).orElse(DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION);
            }
        }
        throw new IllegalStateException("This build tool does not support update " + String.valueOf((Object)buildTool));
    }

    private static boolean isRecipeFile(Path p) {
        return p.getFileName().toString().matches("^\\d\\H+.ya?ml$");
    }

    static boolean shouldApplyRecipe(String recipeFileName, String currentVersion, String targetVersion) {
        String recipeVersion = VERSION_EXTRACTION_PATTERN.matcher(recipeFileName).replaceFirst("");
        ComparableVersion recipeAVersion = new ComparableVersion(recipeVersion);
        ComparableVersion currentAVersion = new ComparableVersion(currentVersion);
        ComparableVersion targetAVersion = new ComparableVersion(targetVersion);
        return currentAVersion.compareTo(recipeAVersion) < 0 && targetAVersion.compareTo(recipeAVersion) >= 0;
    }

    static boolean shouldApplyRecipe(String recipeFileName, Set<VersionUpdate> versions) {
        return versions.stream().anyMatch(version -> QuarkusUpdatesRepository.shouldApplyRecipe(recipeFileName, version.from(), version.to()));
    }

    static List<String> fetchUpdateRecipes(MessageWriter log, ResourceLoader resourceLoader, String location, Map<String, VersionUpdate> recipeDirectoryNames) throws IOException {
        return resourceLoader.loadResourceAsPath(location, path -> QuarkusUpdatesRepository.findRecipeDirectories(path, recipeDirectoryNames).flatMap(d -> {
            Stream stream;
            block9: {
                log.info("* matching recipes directory '%s' found:", new Object[]{d.relativeDir});
                Set<VersionUpdate> versions = d.versions();
                Stream<Path> recipePath = Files.list(path.resolve(d.relativeDir()));
                try {
                    List<String> recipes = recipePath.filter(QuarkusUpdatesRepository::isRecipeFile).filter(p -> QuarkusUpdatesRepository.shouldApplyRecipe(p.getFileName().toString(), versions)).sorted(RecipeVersionComparator.INSTANCE).map(p -> {
                        try {
                            log.info("    - '%s' (%s)", new Object[]{p.getFileName().toString(), versions.stream().map(v -> v.from() + " -> " + v.to()).collect(Collectors.joining(", "))});
                            return new String(Files.readAllBytes(p));
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error reading file: " + String.valueOf(p), e);
                        }
                    }).toList();
                    if (recipes.isEmpty()) {
                        log.info("\t\t- no matching recipes.");
                    }
                    stream = recipes.stream();
                    if (recipePath == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (recipePath != null) {
                            try {
                                recipePath.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error listing files in directory: " + d.relativeDir(), e);
                    }
                }
                recipePath.close();
            }
            return stream;
        }).toList());
    }

    private static Stream<RecipeDirectory> findRecipeDirectories(Path rootDir, Map<String, VersionUpdate> recipeDirectoryNames) {
        return QuarkusUpdatesRepository.findDirsWithRecipes(rootDir).stream().map(d -> {
            String relativeDir = rootDir.relativize((Path)d).toString();
            return QuarkusUpdatesRepository.resolveVersionsForRecipesDir(relativeDir, QuarkusUpdatesRepository.toKey(relativeDir), recipeDirectoryNames);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    public static Set<Path> findDirsWithRecipes(Path startDir) {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.walk(startDir, new FileVisitOption[0]);
            try {
                set = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(QuarkusUpdatesRepository::isRecipeFile).map(Path::getParent).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error while searching for recipe directories in " + String.valueOf(startDir), e);
                }
            }
            stream.close();
        }
        return set;
    }

    private static String toKey(ExtensionUpdateInfo dep) {
        return String.format("%s:%s", dep.getCurrentDep().getArtifact().getGroupId(), dep.getCurrentDep().getArtifact().getArtifactId());
    }

    static String toKey(String relativeDir) {
        return relativeDir.replaceAll("(^[/\\\\])|([/\\\\]$)", "").replaceAll("[/\\\\]", ":");
    }

    static Optional<RecipeDirectory> resolveVersionsForRecipesDir(String dir, String key, Map<String, VersionUpdate> recipeDirectoryNames) {
        Set<VersionUpdate> matches = recipeDirectoryNames.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(key)).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RecipeDirectory(dir, matches));
    }

    record VersionUpdate(String from, String to) {
    }

    public static class FetchResult {
        private final String recipesGAV;
        private final List<String> recipes;
        private final String rewritePluginVersion;

        public FetchResult(String recipesGAV, List<String> recipes, String rewritePluginVersion) {
            this.recipesGAV = recipesGAV;
            this.rewritePluginVersion = rewritePluginVersion;
            this.recipes = recipes;
        }

        public String getRecipesGAV() {
            return this.recipesGAV;
        }

        public List<String> getRecipes() {
            return this.recipes;
        }

        public String getRewritePluginVersion() {
            return this.rewritePluginVersion;
        }
    }

    record RecipeDirectory(String relativeDir, Set<VersionUpdate> versions) {
    }

    private static class RecipeVersionComparator
    implements Comparator<Path> {
        private static final RecipeVersionComparator INSTANCE = new RecipeVersionComparator();

        private RecipeVersionComparator() {
        }

        @Override
        public int compare(Path recipePath1, Path recipePath2) {
            ComparableVersion recipeVersion1 = new ComparableVersion(VERSION_EXTRACTION_PATTERN.matcher(recipePath1.getFileName().toString()).replaceFirst(""));
            ComparableVersion recipeVersion2 = new ComparableVersion(VERSION_EXTRACTION_PATTERN.matcher(recipePath2.getFileName().toString()).replaceFirst(""));
            return recipeVersion1.compareTo(recipeVersion2);
        }
    }
}

