/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.readline.terminal.impl.Pty;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.Config;
import org.aesh.terminal.utils.ExecHelper;
import org.aesh.terminal.utils.OSUtils;

public class ExecPty
implements Pty {
    private static final Logger LOGGER = LoggerUtil.getLogger(ExecPty.class.getName());
    private final String name;
    private final boolean validTTYFile;
    private static final String NOT_A_TTY = "not a tty";

    public static Pty current() throws IOException {
        try {
            LOGGER.log(Level.FINE, "getting pty: " + OSUtils.TTY_COMMAND);
            Process p = new ProcessBuilder(OSUtils.TTY_COMMAND).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
            String result = ExecHelper.waitAndCapture(p).trim();
            if (p.exitValue() != 0) {
                throw new IOException("Not a tty");
            }
            LOGGER.log(Level.FINE, "result: " + result);
            return new ExecPty(result);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e);
        }
    }

    protected ExecPty(String name) {
        this.name = name;
        this.validTTYFile = new File(name).exists() && !NOT_A_TTY.equals(name);
        LOGGER.log(Level.FINE, "tty file " + name + " valid? " + this.validTTYFile);
    }

    @Override
    public void close() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getMasterInput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getMasterOutput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getSlaveInput() throws IOException {
        try {
            if (!this.validTTYFile) {
                return System.in;
            }
            return new FileInputStream(this.getName());
        }
        catch (FileNotFoundException fnfe) {
            return System.in;
        }
    }

    @Override
    public OutputStream getSlaveOutput() throws IOException {
        try {
            if (!this.validTTYFile) {
                return System.out;
            }
            return new FileOutputStream(this.getName());
        }
        catch (FileNotFoundException fnfe) {
            return System.out;
        }
    }

    @Override
    public Attributes getAttr() throws IOException {
        try {
            String cfg = this.doGetConfig();
            if (OSUtils.IS_HPUX || OSUtils.IS_SUNOS) {
                return ExecPty.doGetAttr(cfg);
            }
            if (OSUtils.IS_LINUX) {
                return ExecPty.doGetLinuxAttr(cfg);
            }
            return ExecPty.doGetAttr(cfg);
        }
        catch (IOException ioe) {
            if (ioe.getMessage().contains("Permission denied")) {
                return ExecPty.doGetAttr(this.doGetFailSafeConfig());
            }
            throw ioe;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttr(Attributes attr) throws IOException {
        void var7_17;
        Attributes current = this.getAttr();
        ArrayList<String> commands = new ArrayList<String>();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            if (attr.getInputFlag(inputFlag) == current.getInputFlag(inputFlag)) continue;
            commands.add((attr.getInputFlag(inputFlag) ? inputFlag.name() : "-" + inputFlag.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            if (attr.getOutputFlag((Attributes.OutputFlag)enum_) == current.getOutputFlag((Attributes.OutputFlag)enum_)) continue;
            commands.add((attr.getOutputFlag((Attributes.OutputFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            if (attr.getControlFlag((Attributes.ControlFlag)enum_) == current.getControlFlag((Attributes.ControlFlag)enum_)) continue;
            commands.add((attr.getControlFlag((Attributes.ControlFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            if (attr.getLocalFlag((Attributes.LocalFlag)enum_) == current.getLocalFlag((Attributes.LocalFlag)enum_)) continue;
            commands.add((attr.getLocalFlag((Attributes.LocalFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        String undef = System.getProperty("os.name").toLowerCase().startsWith("hp") ? "^-" : "undef";
        Attributes.ControlChar[] controlCharArray = Attributes.ControlChar.values();
        int n = controlCharArray.length;
        boolean bl = false;
        while (var7_17 < n) {
            Attributes.ControlChar cchar = controlCharArray[var7_17];
            int v = attr.getControlChar(cchar);
            if (v >= 0 && v != current.getControlChar(cchar)) {
                String str = "";
                commands.add(cchar.name().toLowerCase().substring(1));
                if (cchar == Attributes.ControlChar.VMIN || cchar == Attributes.ControlChar.VTIME) {
                    commands.add(Integer.toString(v));
                } else if (v == 0) {
                    commands.add(undef);
                } else {
                    if (v >= 128) {
                        v -= 128;
                        str = str + "M-";
                    }
                    if (v < 32 || v == 127) {
                        v ^= 0x40;
                        str = str + "^";
                    }
                    str = str + (char)v;
                    commands.add(str);
                }
            }
            ++var7_17;
        }
        if (!commands.isEmpty()) {
            if (OSUtils.IS_HPUX || OSUtils.IS_SUNOS) {
                commands.add(0, OSUtils.STTY_COMMAND);
                ExecPty.exec(commands.toArray(new String[commands.size()]));
            } else {
                commands.add(0, OSUtils.STTY_COMMAND);
                commands.add(1, OSUtils.STTY_F_OPTION);
                commands.add(2, this.getName());
                try {
                    ExecPty.exec(commands.toArray(new String[commands.size()]));
                }
                catch (IOException ex) {
                    commands.remove(2);
                    commands.remove(1);
                    ExecPty.exec(commands.toArray(new String[commands.size()]));
                }
            }
        }
    }

    @Override
    public Size getSize() throws IOException {
        if (OSUtils.IS_HPUX) {
            return ExecPty.doGetOptimalSize(ExecPty.exec(OSUtils.STTY_COMMAND, "size"));
        }
        if (OSUtils.IS_SUNOS) {
            String config = this.doGetConfig();
            return new Size(ExecPty.doGetInt("columns", config), ExecPty.doGetInt("rows", config));
        }
        try {
            return ExecPty.doGetOptimalSize(ExecPty.exec(OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "size"));
        }
        catch (IOException ex) {
            return ExecPty.doGetOptimalSize(ExecPty.exec(OSUtils.STTY_COMMAND, "size"));
        }
    }

    protected String doGetConfig() throws IOException {
        if (OSUtils.IS_HPUX || OSUtils.IS_SUNOS) {
            return ExecPty.exec(OSUtils.STTY_COMMAND, "-a");
        }
        try {
            return ExecPty.exec(OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "-a");
        }
        catch (IOException ex) {
            return ExecPty.exec(OSUtils.STTY_COMMAND, "-a");
        }
    }

    private String doGetFailSafeConfig() throws IOException {
        return ExecPty.exec(OSUtils.STTY_COMMAND, "-a");
    }

    static Attributes doGetLinuxAttr(String cfg) {
        Attributes attributes = new Attributes();
        String[] attr = cfg.split(";");
        ExecPty.setAttr(Attributes.ControlChar.VINTR, attr[4], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VQUIT, attr[5], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VERASE, attr[6], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VKILL, attr[7], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VEOF, attr[8], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VEOL, attr[9], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VEOL2, attr[10], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VSTART, attr[12], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VSTOP, attr[13], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VSUSP, attr[14], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VREPRINT, attr[15], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VWERASE, attr[16], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VLNEXT, attr[17], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VDISCARD, attr[18], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VMIN, attr[19], attributes);
        ExecPty.setAttr(Attributes.ControlChar.VTIME, attr[20], attributes);
        ExecPty.doParseLinuxOptions(attr[21], attributes);
        return attributes;
    }

    private static void doParseLinuxOptions(String options, Attributes attributes) {
        String[] optionLines;
        for (String line : optionLines = options.split(Config.getLineSeparator())) {
            for (String option : line.trim().split(" ")) {
                if ((option = option.trim()).length() <= 0 || option.charAt(0) == '-') continue;
                Attributes.ControlFlag controlFlag = ExecPty.getEnumFromString(Attributes.ControlFlag.class, option);
                if (controlFlag != null) {
                    attributes.setControlFlag(controlFlag, true);
                    continue;
                }
                Attributes.InputFlag inputFlag = ExecPty.getEnumFromString(Attributes.InputFlag.class, option);
                if (inputFlag != null) {
                    attributes.setInputFlag(inputFlag, true);
                    continue;
                }
                Attributes.LocalFlag localFlag = ExecPty.getEnumFromString(Attributes.LocalFlag.class, option);
                if (localFlag != null) {
                    attributes.setLocalFlag(localFlag, true);
                    continue;
                }
                Attributes.OutputFlag outputFlag = ExecPty.getEnumFromString(Attributes.OutputFlag.class, option);
                if (outputFlag == null) continue;
                attributes.setOutputFlag(outputFlag, true);
            }
        }
    }

    private static void setAttr(Attributes.ControlChar cc, String input, Attributes attr) {
        attr.setControlChar(cc, ExecPty.parseControlChar(input.substring(input.lastIndexOf(32) + 1)));
    }

    private static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        for (Enum flag : (Enum[])c.getEnumConstants()) {
            if (!flag.name().toLowerCase().equals(string)) continue;
            return (T)flag;
        }
        return null;
    }

    static Attributes doGetAttr(String cfg) throws IOException {
        Boolean value;
        Attributes attributes = new Attributes();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            value = ExecPty.doGetFlag(cfg, inputFlag);
            if (value == null) continue;
            attributes.setInputFlag(inputFlag, value);
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setOutputFlag((Attributes.OutputFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setControlFlag((Attributes.ControlFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setLocalFlag((Attributes.LocalFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.ControlChar.values()) {
            Matcher matcher;
            String name = enum_.name().toLowerCase().substring(1);
            if ("reprint".endsWith(name)) {
                name = "(?:reprint|rprnt)";
            }
            if (!(matcher = Pattern.compile("[\\s;]" + name + "\\s*=\\s*(.+?)[\\s;]").matcher(cfg)).find()) continue;
            attributes.setControlChar((Attributes.ControlChar)enum_, ExecPty.parseControlChar(matcher.group(1).toUpperCase()));
        }
        return attributes;
    }

    private static Boolean doGetFlag(String cfg, Enum<?> flag) {
        Matcher matcher = Pattern.compile("(?:^|[\\s;])(\\-?" + flag.name().toLowerCase() + ")(?:[\\s;]|$)").matcher(cfg);
        return matcher.find() ? Boolean.valueOf(!matcher.group(1).startsWith("-")) : null;
    }

    static int parseControlChar(String str) {
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        if ("<UNDEF>".equals(str) || "<undef>".equals(str)) {
            return -1;
        }
        if ("DEL".equalsIgnoreCase(str)) {
            return 127;
        }
        return str.charAt(0);
    }

    static Size doGetHPUXSize(String cfg) {
        String[] tokens = cfg.split(";");
        return new Size(Integer.parseInt(tokens[4].substring(9)), Integer.parseInt(tokens[2].substring(7)));
    }

    private static Size doGetOptimalSize(String cfg) throws IOException {
        String[] size = cfg.split(" ");
        return new Size(Integer.parseInt(size[1].trim()), Integer.parseInt(size[0].trim()));
    }

    static Size doGetSize(String cfg) throws IOException {
        return new Size(ExecPty.doGetInt("columns", cfg), ExecPty.doGetInt("rows", cfg));
    }

    private static int doGetInt(String name, String cfg) throws IOException {
        String[] patterns;
        for (String pattern : patterns = new String[]{"\\b([0-9]+)\\s+" + name + "\\b", "\\b" + name + "\\s+([0-9]+)\\b", "\\b" + name + "\\s*=\\s*([0-9]+)\\b"}) {
            Matcher matcher = Pattern.compile(pattern).matcher(cfg);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        throw new IOException("Unable to parse " + name);
    }

    private static String exec(String ... cmd) throws IOException {
        assert (cmd != null && cmd[0].length() > 0);
        try {
            LOGGER.log(Level.FINE, "Running: " + Arrays.toString(cmd));
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            Process p = processBuilder.start();
            String result = ExecHelper.waitAndCapture(p);
            LOGGER.log(Level.FINE, "Result: " + result);
            if (p.exitValue() != 0) {
                throw new IOException("Error executing '" + String.join((CharSequence)" ", cmd) + "': " + result);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e);
        }
    }
}

