/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Collection;
import java.util.Objects;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ConvertedBasicCollectionType<C extends Collection<E>, E>
extends BasicCollectionType<C, E> {
    private final BasicValueConverter<C, ?> converter;
    private final ValueExtractor<C> jdbcValueExtractor;
    private final ValueBinder<C> jdbcValueBinder;
    private final JdbcLiteralFormatter<C> jdbcLiteralFormatter;

    public ConvertedBasicCollectionType(BasicType<E> baseDescriptor, JdbcType arrayJdbcType, BasicCollectionJavaType<C, E> arrayTypeDescriptor, BasicValueConverter<C, ?> converter) {
        super(baseDescriptor, arrayJdbcType, arrayTypeDescriptor);
        this.converter = converter;
        this.jdbcValueBinder = arrayJdbcType.getBinder(converter.getRelationalJavaType());
        this.jdbcValueExtractor = arrayJdbcType.getExtractor(converter.getRelationalJavaType());
        this.jdbcLiteralFormatter = arrayJdbcType.getJdbcLiteralFormatter(converter.getRelationalJavaType());
    }

    @Override
    public BasicValueConverter<C, ?> getValueConverter() {
        return this.converter;
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.converter.getRelationalJavaType();
    }

    @Override
    public ValueExtractor<C> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<C> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public JdbcLiteralFormatter<C> getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || super.equals(o) && o instanceof ConvertedBasicCollectionType && Objects.equals(this.converter, ((ConvertedBasicCollectionType)o).converter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.converter.hashCode();
        return result;
    }
}

