/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class AggregateColumnAssignmentHandler {
    private final TypeConfiguration typeConfiguration;
    private final AggregateSupport aggregateSupport;
    private final HashMap<SelectablePath, EmbeddableMappingType> rootAggregates;
    private final int assignmentCount;
    private final LinkedHashMap<EmbeddableMappingType, BitSet> aggregateAssignmentPositions;

    private AggregateColumnAssignmentHandler(EntityPersister entityDescriptor, int assignmentCount) {
        HashMap<SelectablePath, EmbeddableMappingType> rootAggregates = new HashMap<SelectablePath, EmbeddableMappingType>();
        AggregateColumnAssignmentHandler.collectRootAggregates(rootAggregates, entityDescriptor);
        this.typeConfiguration = entityDescriptor.getFactory().getTypeConfiguration();
        this.aggregateSupport = entityDescriptor.getFactory().getJdbcServices().getDialect().getAggregateSupport();
        this.rootAggregates = rootAggregates;
        this.assignmentCount = assignmentCount;
        this.aggregateAssignmentPositions = new LinkedHashMap();
    }

    private static void collectRootAggregates(HashMap<SelectablePath, EmbeddableMappingType> rootAggregates, ManagedMappingType mappingType) {
        int numberOfAttributeMappings = mappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = mappingType.getAttributeMapping(i);
            MappingType mappedType = attributeMapping.getMappedType();
            if (!(mappedType instanceof EmbeddableMappingType)) continue;
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            SelectableMapping aggregateMapping = embeddableMappingType.getAggregateMapping();
            if (aggregateMapping == null) {
                AggregateColumnAssignmentHandler.collectRootAggregates(rootAggregates, embeddableMappingType);
                continue;
            }
            rootAggregates.put(aggregateMapping.getSelectablePath(), embeddableMappingType);
        }
    }

    static AggregateColumnAssignmentHandler forEntityDescriptor(EntityPersister entityDescriptor, int size) {
        if (entityDescriptor.anyRequiresAggregateColumnWriter()) {
            return new AggregateColumnAssignmentHandler(entityDescriptor, size);
        }
        return null;
    }

    public void addAssignment(int position, ColumnReference columnReference) {
        EmbeddableMappingType aggregateType = this.findAggregateToCombine(columnReference.getSelectablePath());
        if (aggregateType == null) {
            return;
        }
        assert (aggregateType.requiresAggregateColumnWriter());
        BitSet positions = this.aggregateAssignmentPositions.get(aggregateType);
        if (positions == null) {
            positions = new BitSet(this.assignmentCount);
            this.aggregateAssignmentPositions.put(aggregateType, positions);
        }
        positions.set(position);
    }

    public void aggregateAssignments(ArrayList<Assignment> assignments) {
        ArrayList<Assignment> aggregateAssignments = new ArrayList<Assignment>(this.aggregateAssignmentPositions.size());
        BitSet consumedPositions = new BitSet(this.assignmentCount);
        for (Map.Entry<EmbeddableMappingType, BitSet> entry : this.aggregateAssignmentPositions.entrySet()) {
            EmbeddableMappingType aggregateType = entry.getKey();
            BitSet assignmentPositions = entry.getValue();
            int assignmentsPositionCount = assignmentPositions.cardinality();
            SelectableMapping aggregateMapping = aggregateType.getAggregateMapping();
            ColumnReference aggregateColumnReference = new ColumnReference(assignments.get(assignmentPositions.nextSetBit(0)).getAssignable().getColumnReferences().get(0).getQualifier(), aggregateMapping);
            SelectableMapping[] columnMappings = new SelectableMapping[assignmentsPositionCount];
            Expression[] valueExpressions = new Expression[assignmentsPositionCount];
            int assignmentPosition = assignmentPositions.nextSetBit(0);
            int i = 0;
            while (assignmentPosition >= 0) {
                Assignment assignment = assignments.get(assignmentPosition);
                List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
                assert (columnReferences.size() == 1);
                columnMappings[i] = this.findSelectable(aggregateType, columnReferences.get(0));
                valueExpressions[i] = assignment.getAssignedValue();
                consumedPositions.set(assignmentPosition);
                assignmentPosition = assignmentPositions.nextSetBit(assignmentPosition + 1);
                ++i;
            }
            AggregateSupport.WriteExpressionRenderer writeExpression = this.aggregateSupport.aggregateCustomWriteExpressionRenderer(aggregateMapping, columnMappings, this.typeConfiguration);
            aggregateAssignments.add(new Assignment(aggregateColumnReference, new AggregateColumnWriteExpression(aggregateColumnReference, writeExpression, columnMappings, valueExpressions)));
        }
        if (aggregateAssignments.isEmpty()) {
            return;
        }
        int endIndex = this.assignmentCount - 1;
        int aggregateAssignmentIndex = aggregateAssignments.size() - 1;
        int aggregateEndIndex = consumedPositions.previousSetBit(endIndex);
        do {
            int regularAssignments;
            int assignmentEndIndex = consumedPositions.previousClearBit(aggregateEndIndex);
            int aggregateStartIndex = assignmentEndIndex + 1;
            for (int i = regularAssignments = endIndex - aggregateEndIndex; i != 0; --i) {
                assignments.set(aggregateStartIndex + i, assignments.remove(aggregateEndIndex + i));
            }
            int newEnd = aggregateStartIndex + regularAssignments + 1;
            for (int i = aggregateEndIndex - regularAssignments; i >= newEnd; --i) {
                assignments.remove(i);
            }
            assignments.set(aggregateStartIndex, (Assignment)aggregateAssignments.get(aggregateAssignmentIndex));
            endIndex = assignmentEndIndex;
            aggregateEndIndex = consumedPositions.previousSetBit(endIndex);
            --aggregateAssignmentIndex;
        } while (aggregateEndIndex != -1);
        assert (aggregateAssignmentIndex == -1);
    }

    private SelectableMapping findSelectable(EmbeddableMappingType aggregateType, ColumnReference columnReference) {
        SelectablePath aggregateSelectablePath = aggregateType.getAggregateMapping().getSelectablePath();
        SelectablePath[] relativeSelectablePaths = columnReference.getSelectablePath().relativize(aggregateSelectablePath);
        int end = relativeSelectablePaths.length - 1;
        for (int i = 0; i < end; ++i) {
            SelectableMapping selectable = aggregateType.getJdbcValueSelectable(aggregateType.getSelectableIndex(relativeSelectablePaths[i].getSelectableName()));
            aggregateType = ((AggregateJdbcType)selectable.getJdbcMapping().getJdbcType()).getEmbeddableMappingType();
        }
        return aggregateType.getJdbcValueSelectable(aggregateType.getSelectableIndex(relativeSelectablePaths[end].getSelectableName()));
    }

    private EmbeddableMappingType findAggregateToCombine(SelectablePath selectablePath) {
        SelectablePath[] parts = selectablePath.getParts();
        for (int i = parts.length - 2; i >= 0; --i) {
            EmbeddableMappingType embeddableMappingType = this.rootAggregates.get(parts[i]);
            if (embeddableMappingType == null || !embeddableMappingType.requiresAggregateColumnWriter()) continue;
            return embeddableMappingType;
        }
        return null;
    }
}

