/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.sql.model.TableMapping;

public class CollectionTableMapping
implements TableMapping {
    private final String tableName;
    private final String[] spaces;
    private final boolean isJoinTable;
    private final boolean isInverse;
    private final TableMapping.MutationDetails insertDetails;
    private final TableMapping.MutationDetails updateDetails;
    private final boolean cascadeDeleteEnabled;
    private final TableMapping.MutationDetails deleteAllDetails;
    private final TableMapping.MutationDetails deleteRowDetails;

    public CollectionTableMapping(String tableName, String[] spaces, boolean isJoinTable, boolean isInverse, TableMapping.MutationDetails insertDetails, TableMapping.MutationDetails updateDetails, boolean cascadeDeleteEnabled, TableMapping.MutationDetails deleteAllDetails, TableMapping.MutationDetails deleteRowDetails) {
        this.tableName = tableName;
        this.spaces = spaces;
        this.isJoinTable = isJoinTable;
        this.isInverse = isInverse;
        this.insertDetails = insertDetails;
        this.updateDetails = updateDetails;
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
        this.deleteAllDetails = deleteAllDetails;
        this.deleteRowDetails = deleteRowDetails;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public String[] getSpaces() {
        return this.spaces;
    }

    @Override
    public boolean containsTableName(String tableName) {
        if (this.tableName.equals(tableName)) {
            return true;
        }
        for (String space : this.spaces) {
            if (!space.equals(tableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableDetails.KeyDetails getKeyDetails() {
        return null;
    }

    public boolean isJoinTable() {
        return this.isJoinTable;
    }

    @Override
    public int getRelativePosition() {
        return 0;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public boolean isIdentifierTable() {
        return true;
    }

    @Override
    public TableMapping.MutationDetails getInsertDetails() {
        return this.insertDetails;
    }

    @Override
    public TableMapping.MutationDetails getUpdateDetails() {
        return this.updateDetails;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    @Override
    public TableMapping.MutationDetails getDeleteDetails() {
        return this.deleteAllDetails;
    }

    public TableMapping.MutationDetails getDeleteRowDetails() {
        return this.deleteRowDetails;
    }
}

