/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.dialect.function.array.ElementViaArrayArgumentReturnTypeResolver;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class ArrayGetUnnestFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public ArrayGetUnnestFunction() {
        super("array_get", StandardArgumentsValidators.composite(ArrayArgumentValidator.DEFAULT_INSTANCE, new ArgumentTypesValidator(null, FunctionParameterType.ANY, FunctionParameterType.INTEGER)), ElementViaArrayArgumentReturnTypeResolver.DEFAULT_INSTANCE, StandardFunctionArgumentTypeResolvers.invariant(FunctionParameterType.ANY, FunctionParameterType.INTEGER));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append("(select t.val from unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append(") with ordinality t(val, idx) where t.idx=");
        indexExpression.accept(walker);
        sqlAppender.append(')');
    }
}

