/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transaction.operations.CompleteTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.operations.ForgetTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.operations.RecoveryOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class TransactionOperationFactory {
    private final Configuration configuration;
    private final ChannelFactory channelFactory;
    private final AtomicReference<ClientTopology> clientTopology;

    public TransactionOperationFactory(Configuration configuration, ChannelFactory channelFactory) {
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.clientTopology = channelFactory.createTopologyId(HotRodConstants.DEFAULT_CACHE_NAME_BYTES);
    }

    CompleteTransactionOperation newCompleteTransactionOperation(Xid xid, boolean commit) {
        return new CompleteTransactionOperation(this.channelFactory.getNegotiatedCodec(), this.channelFactory, this.clientTopology, this.configuration, xid, commit);
    }

    ForgetTransactionOperation newForgetTransactionOperation(Xid xid) {
        return new ForgetTransactionOperation(this.channelFactory.getNegotiatedCodec(), this.channelFactory, this.clientTopology, this.configuration, xid);
    }

    RecoveryOperation newRecoveryOperation() {
        return new RecoveryOperation(this.channelFactory.getNegotiatedCodec(), this.channelFactory, this.clientTopology, this.configuration);
    }
}

