/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.events.XSiteEventType;

public final class XSiteEvent {
    private static final XSiteEventType[] CACHED_TYPE = XSiteEventType.values();
    private final XSiteEventType type;
    private final ByteString siteName;
    private final ByteString cacheName;

    private XSiteEvent(XSiteEventType type, ByteString siteName, ByteString cacheName) {
        this.type = Objects.requireNonNull(type);
        this.siteName = siteName;
        this.cacheName = cacheName;
    }

    private static XSiteEventType typeFrom(int ordinal) {
        return CACHED_TYPE[ordinal];
    }

    public static XSiteEvent createConnectEvent(ByteString localSite) {
        return new XSiteEvent(XSiteEventType.SITE_CONNECTED, Objects.requireNonNull(localSite), null);
    }

    public static XSiteEvent createRequestState(ByteString localSite, ByteString cacheName) {
        return new XSiteEvent(XSiteEventType.STATE_REQUEST, Objects.requireNonNull(localSite), Objects.requireNonNull(cacheName));
    }

    public static XSiteEvent createInitialStateRequest(ByteString localSite, ByteString cacheName) {
        return new XSiteEvent(XSiteEventType.INITIAL_STATE_REQUEST, Objects.requireNonNull(localSite), Objects.requireNonNull(cacheName));
    }

    public XSiteEventType getType() {
        return this.type;
    }

    public ByteString getSiteName() {
        return this.siteName;
    }

    public ByteString getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return "XSiteEvent{type=" + String.valueOf((Object)this.type) + ", siteName=" + String.valueOf(this.siteName) + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSiteEvent that = (XSiteEvent)o;
        if (this.type != that.type) {
            return false;
        }
        if (!Objects.equals(this.siteName, that.siteName)) {
            return false;
        }
        return Objects.equals(this.cacheName, that.cacheName);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.siteName != null ? this.siteName.hashCode() : 0);
        result = 31 * result + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return result;
    }

    public static void writeTo(ObjectOutput output, XSiteEvent event) throws IOException {
        MarshallUtil.marshallEnum((Enum)event.type, (ObjectOutput)output);
        switch (event.type) {
            case SITE_CONNECTED: {
                ByteString.writeObject(output, event.siteName);
                return;
            }
            case STATE_REQUEST: 
            case INITIAL_STATE_REQUEST: {
                ByteString.writeObject(output, event.siteName);
                ByteString.writeObject(output, event.cacheName);
            }
        }
    }

    public static XSiteEvent readFrom(ObjectInput input) throws IOException {
        XSiteEventType type = (XSiteEventType)MarshallUtil.unmarshallEnum((ObjectInput)input, XSiteEvent::typeFrom);
        assert (type != null);
        switch (type) {
            case SITE_CONNECTED: {
                return XSiteEvent.createConnectEvent(ByteString.readObject(input));
            }
            case STATE_REQUEST: {
                return XSiteEvent.createRequestState(ByteString.readObject(input), ByteString.readObject(input));
            }
            case INITIAL_STATE_REQUEST: {
                return XSiteEvent.createInitialStateRequest(ByteString.readObject(input), ByteString.readObject(input));
            }
        }
        throw new IllegalStateException();
    }
}

