/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.SuppressForbidden;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.Type;

public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    static final String ADD_OBSERVERS = "addObservers";
    static final String ADD_REMOVED_BEANS = "addRemovedBeans";
    static final String ADD_BEANS = "addBeans";
    private final AnnotationLiteralProcessor annotationLiterals;
    private final boolean detectUnusedFalsePositives;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals, boolean generateSources, boolean detectUnusedFalsePositives) {
        super(generateSources);
        this.annotationLiterals = annotationLiterals;
        this.detectUnusedFalsePositives = detectUnusedFalsePositives;
    }

    /*
     * WARNING - void declaration
     */
    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName, Map<DotName, String> scopeToContextInstances) {
        void var20_39;
        void var17_28;
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        ClassCreator componentsProvider = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ComponentsProvider.class}).build();
        MethodCreator getComponents = (MethodCreator)componentsProvider.getMethodCreator("getComponents", Components.class, new Class[]{CurrentContextFactory.class}).setModifiers(1);
        Map<BeanInfo, List<BeanInfo>> dependencyMap = this.initBeanDependencyMap(beanDeployment);
        ResultHandle beanIdToBeanHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processBeans(componentsProvider, getComponents, beanIdToBeanHandle, dependencyMap, beanToGeneratedName, beanDeployment);
        ResultHandle observersHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processObservers(componentsProvider, getComponents, beanDeployment, beanIdToBeanHandle, observersHandle, observerToGeneratedName);
        ResultHandle contextsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<ScopeInfo, List<Function<MethodCreator, ResultHandle>>> entry : beanDeployment.getCustomContexts().entrySet()) {
            for (Function<MethodCreator, ResultHandle> function : entry.getValue()) {
                ResultHandle contextHandle = function.apply(getComponents);
                getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, contextsHandle, new ResultHandle[]{contextHandle});
            }
        }
        ResultHandle interceptorBindings = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ClassInfo classInfo : beanDeployment.getInterceptorBindings()) {
            getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, interceptorBindings, new ResultHandle[]{getComponents.load(classInfo.name().toString())});
        }
        ResultHandle resultHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<AnnotationInstance>> entry : beanDeployment.getTransitiveInterceptorBindings().entrySet()) {
            ResultHandle bindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance annotationInstance : entry.getValue()) {
                ClassInfo classInfo = beanDeployment.getInterceptorBinding(annotationInstance.name());
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.create((BytecodeCreator)getComponents, classInfo, annotationInstance)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, resultHandle, new ResultHandle[]{getComponents.loadClass(entry.getKey().toString()), bindingsHandle});
        }
        ResultHandle resultHandle2 = getComponents.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"values", Collection.class, (Class[])new Class[0]), beanIdToBeanHandle, new ResultHandle[0]);
        if (this.detectUnusedFalsePositives) {
            FunctionCreator removedBeansSupplierFun = getComponents.createFunction(Supplier.class);
            BytecodeCreator removedBeansSupplierBytecode = removedBeansSupplierFun.getBytecode();
            ResultHandle resultHandle3 = removedBeansSupplierBytecode.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle resultHandle4 = removedBeansSupplierBytecode.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            this.processRemovedBeans(componentsProvider, removedBeansSupplierBytecode, resultHandle3, resultHandle4, beanDeployment, classOutput);
            removedBeansSupplierBytecode.returnValue(resultHandle3);
            ResultHandle resultHandle5 = removedBeansSupplierFun.getInstance();
        } else {
            ResultHandle resultHandle6 = getComponents.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{getComponents.invokeStaticMethod(MethodDescriptors.COLLECTIONS_EMPTY_SET, new ResultHandle[0])});
        }
        ResultHandle qualifiers = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ClassInfo classInfo : beanDeployment.getQualifiers()) {
            getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{getComponents.load(classInfo.name().toString())});
        }
        ResultHandle qualifiersNonbindingMembers = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<String>> entry : beanDeployment.getQualifierNonbindingMembers().entrySet()) {
            ResultHandle resultHandle7 = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String member : entry.getValue()) {
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, resultHandle7, new ResultHandle[]{getComponents.load(member)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, qualifiersNonbindingMembers, new ResultHandle[]{getComponents.load(entry.getKey().toString()), resultHandle7});
        }
        if (scopeToContextInstances.isEmpty()) {
            ResultHandle resultHandle8 = getComponents.invokeStaticMethod(MethodDescriptors.COLLECTIONS_EMPTY_MAP, new ResultHandle[0]);
        } else {
            ResultHandle resultHandle9 = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (Map.Entry<DotName, String> entry : scopeToContextInstances.entrySet()) {
                ResultHandle scope = getComponents.loadClass(entry.getKey().toString());
                FunctionCreator supplier = getComponents.createFunction(Supplier.class);
                BytecodeCreator bytecode = supplier.getBytecode();
                bytecode.returnValue(bytecode.newInstance(MethodDescriptor.ofConstructor((String)entry.getValue(), (String[])new String[0]), new ResultHandle[0]));
                getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, resultHandle9, new ResultHandle[]{scope, supplier.getInstance()});
            }
        }
        ResultHandle resultHandle10 = getComponents.newInstance(MethodDescriptor.ofConstructor(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Set.class, Map.class, Supplier.class, Map.class, Set.class, Map.class}), new ResultHandle[]{resultHandle2, observersHandle, contextsHandle, interceptorBindings, resultHandle, var17_28, qualifiersNonbindingMembers, qualifiers, var20_39});
        getComponents.returnValue(resultHandle10);
        componentsProvider.close();
        ArrayList<ResourceOutput.Resource> arrayList = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            arrayList.add(resource);
            if (!resource.getName().endsWith(COMPONENTS_PROVIDER_SUFFIX)) continue;
            arrayList.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(StandardCharsets.UTF_8), null));
        }
        return arrayList;
    }

    private void processBeans(ClassCreator componentsProvider, MethodCreator getComponents, ResultHandle beanIdToBeanHandle, final Map<BeanInfo, List<BeanInfo>> dependencyMap, Map<BeanInfo, String> beanToGeneratedName, BeanDeployment beanDeployment) {
        HashSet<BeanInfo> processed = new HashSet<BeanInfo>();
        BeanAdder beanAdder = new BeanAdder(componentsProvider, getComponents, processed, beanIdToBeanHandle, beanToGeneratedName);
        Predicate<BeanInfo> isNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                return !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        Predicate<BeanInfo> isNormalScopedOrNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                return b.getScope().isNormal() || !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        Predicate<BeanInfo> isNotProducerOrNormalScopedOrNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                if (b.isProducer()) {
                    return false;
                }
                return b.getScope().isNormal() || !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        boolean stuck = false;
        while (!dependencyMap.isEmpty()) {
            if (stuck) {
                throw this.circularDependenciesNotSupportedException(dependencyMap);
            }
            stuck = true;
            stuck = this.addBeans(beanAdder, dependencyMap, processed, isNotDependencyPredicate);
            if (!stuck || !(stuck = this.addBeans(beanAdder, dependencyMap, processed, isNotProducerOrNormalScopedOrNotDependencyPredicate))) continue;
            stuck = this.addBeans(beanAdder, dependencyMap, processed, isNormalScopedOrNotDependencyPredicate);
        }
        for (BeanInfo beanInfo : beanDeployment.getBeans()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addComponent(beanInfo);
        }
        for (BeanInfo beanInfo : beanDeployment.getInterceptors()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addComponent(beanInfo);
        }
        for (BeanInfo beanInfo : beanDeployment.getDecorators()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addComponent(beanInfo);
        }
        beanAdder.close();
    }

    private IllegalStateException circularDependenciesNotSupportedException(Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        StringBuilder msg = new StringBuilder("Circular dependencies not supported: \n");
        for (Map.Entry<BeanInfo, List<BeanInfo>> e : beanToInjections.entrySet()) {
            msg.append("\t ");
            msg.append(e.getKey());
            msg.append(" injected into: ");
            msg.append(e.getValue().stream().map(BeanInfo::getBeanClass).map(Object::toString).collect(Collectors.joining(", ")));
            msg.append("\n");
        }
        return new IllegalStateException(msg.toString());
    }

    private void processObservers(ClassCreator componentsProvider, MethodCreator getComponents, BeanDeployment beanDeployment, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle, Map<ObserverInfo, String> observerToGeneratedName) {
        try (ObserverAdder observerAdder = new ObserverAdder(componentsProvider, getComponents, observerToGeneratedName, beanIdToBeanHandle, observersHandle);){
            for (ObserverInfo observer : beanDeployment.getObservers()) {
                observerAdder.addComponent(observer);
            }
        }
    }

    private void processRemovedBeans(ClassCreator componentsProvider, BytecodeCreator targetMethod, ResultHandle removedBeansHandle, ResultHandle typeCacheHandle, BeanDeployment beanDeployment, ClassOutput classOutput) {
        try (RemovedBeanAdder removedBeanAdder = new RemovedBeanAdder(componentsProvider, targetMethod, removedBeansHandle, typeCacheHandle, classOutput);){
            for (BeanInfo remnovedBean : beanDeployment.getRemovedBeans()) {
                removedBeanAdder.addComponent(remnovedBean);
            }
        }
    }

    private Map<BeanInfo, List<BeanInfo>> initBeanDependencyMap(BeanDeployment beanDeployment) {
        Function<BeanInfo, List<BeanInfo>> newArrayList = new Function<BeanInfo, List<BeanInfo>>(){

            @Override
            public List<BeanInfo> apply(BeanInfo b) {
                return new ArrayList<BeanInfo>();
            }
        };
        HashMap<BeanInfo, List<BeanInfo>> beanToInjections = new HashMap<BeanInfo, List<BeanInfo>>();
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducer() && !bean.isStaticProducer()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), newArrayList).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(bean);
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptor, newArrayList).add(bean);
            }
            for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                beanToInjections.computeIfAbsent(decorator, newArrayList).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(interceptor);
                }
            }
        }
        for (DecoratorInfo decorator : beanDeployment.getDecorators()) {
            for (Injection injection : decorator.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (injectionPoint.isDelegate() || BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(decorator);
                }
            }
        }
        return beanToInjections;
    }

    private boolean addBeans(BeanAdder beanAdder, Map<BeanInfo, List<BeanInfo>> beanToInjections, Set<BeanInfo> processed, Predicate<BeanInfo> filter) {
        boolean stuck = true;
        Iterator<BeanInfo> iterator = beanToInjections.keySet().iterator();
        while (iterator.hasNext()) {
            BeanInfo bean = iterator.next();
            if (!filter.test(bean)) continue;
            iterator.remove();
            beanAdder.addComponent(bean);
            processed.add(bean);
            stuck = false;
        }
        return stuck;
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> dependencyMap) {
        for (List<BeanInfo> dependants : dependencyMap.values()) {
            if (!dependants.contains(bean)) continue;
            return true;
        }
        return false;
    }

    static class BeanAdder
    extends ComponentAdder<BeanInfo> {
        private final Set<BeanInfo> processedBeans;
        private final ResultHandle beanIdToBeanHandle;
        private final Map<BeanInfo, String> beanToGeneratedName;

        public BeanAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, Set<BeanInfo> processed, ResultHandle beanIdToBeanHandle, Map<BeanInfo, String> beanToGeneratedName) {
            super((BytecodeCreator)getComponentsMethod, componentsProvider);
            this.processedBeans = processed;
            this.beanIdToBeanHandle = beanIdToBeanHandle;
            this.beanToGeneratedName = beanToGeneratedName;
        }

        @Override
        MethodCreator newAddMethod() {
            return (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_BEANS + this.group++, Void.TYPE, new Class[]{Map.class}).setModifiers(2);
        }

        @Override
        void invokeAddMethod() {
            this.targetMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class}), this.targetMethod.getThis(), new ResultHandle[]{this.beanIdToBeanHandle});
        }

        @Override
        void addComponentInternal(BeanInfo bean) {
            ResultHandle beanIdToBeanHandle = this.addMethod.getMethodParam(0);
            String beanType = this.beanToGeneratedName.get(bean);
            if (beanType == null) {
                throw new IllegalStateException("No bean type found for: " + String.valueOf(bean));
            }
            List injectionPoints = bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !ip.isDelegate() && !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            if (bean.isProducer()) {
                if (this.processedBeans.contains(bean.getDeclaringBean())) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(bean.getDeclaringBean().getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(bean.getDeclaringBean().getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                if (this.processedBeans.contains(injectionPoint.getResolvedBean())) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                    paramTypes.add(Type.getDescriptor(Supplier.class));
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                if (this.processedBeans.contains(interceptor)) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(interceptor.getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(interceptor.getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                if (this.processedBeans.contains(decorator)) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(decorator.getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(decorator.getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            ResultHandle beanInstance = this.addMethod.newInstance(MethodDescriptor.ofConstructor((String)beanType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            ResultHandle beanIdHandle = this.addMethod.load(bean.getIdentifier());
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, beanIdToBeanHandle, new ResultHandle[]{beanIdHandle, beanInstance});
        }
    }

    static class ObserverAdder
    extends ComponentAdder<ObserverInfo> {
        private final Map<ObserverInfo, String> observerToGeneratedName;
        private final ResultHandle beanIdToBeanHandle;
        private final ResultHandle observersHandle;

        ObserverAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, Map<ObserverInfo, String> observerToGeneratedName, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle) {
            super((BytecodeCreator)getComponentsMethod, componentsProvider);
            this.observerToGeneratedName = observerToGeneratedName;
            this.beanIdToBeanHandle = beanIdToBeanHandle;
            this.observersHandle = observersHandle;
        }

        @Override
        MethodCreator newAddMethod() {
            return (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_OBSERVERS + this.group++, Void.TYPE, new Class[]{Map.class, List.class}).setModifiers(2);
        }

        @Override
        void invokeAddMethod() {
            this.targetMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class, List.class}), this.targetMethod.getThis(), new ResultHandle[]{this.beanIdToBeanHandle, this.observersHandle});
        }

        @Override
        void addComponentInternal(ObserverInfo observer) {
            ResultHandle beanIdToBeanHandle = this.addMethod.getMethodParam(0);
            ResultHandle observersHandle = this.addMethod.getMethodParam(1);
            String observerType = this.observerToGeneratedName.get(observer);
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            if (!observer.isSynthetic()) {
                List injectionPoints = observer.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
                params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(observer.getDeclaringBean().getIdentifier())}));
                paramTypes.add(Type.getDescriptor(Supplier.class));
                for (InjectionPointInfo injectionPoint : injectionPoints) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                    paramTypes.add(Type.getDescriptor(Supplier.class));
                }
            }
            ResultHandle observerInstance = this.addMethod.newInstance(MethodDescriptor.ofConstructor((String)observerType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, observersHandle, new ResultHandle[]{observerInstance});
        }
    }

    class RemovedBeanAdder
    extends ComponentAdder<BeanInfo> {
        private final ResultHandle removedBeansHandle;
        private final ResultHandle typeCacheHandle;
        private ResultHandle tccl;
        private final Map<AnnotationInstanceKey, ResultHandle> sharedQualifers;
        private final MapTypeCache typeCache;

        public RemovedBeanAdder(ClassCreator componentsProvider, BytecodeCreator targetMethod, ResultHandle removedBeansHandle, ResultHandle typeCacheHandle, ClassOutput classOutput) {
            super(targetMethod, componentsProvider);
            this.removedBeansHandle = removedBeansHandle;
            this.typeCacheHandle = typeCacheHandle;
            this.sharedQualifers = new HashMap<AnnotationInstanceKey, ResultHandle>();
            this.typeCache = new MapTypeCache();
        }

        @Override
        protected int groupLimit() {
            return 5;
        }

        @Override
        MethodCreator newAddMethod() {
            this.sharedQualifers.clear();
            MethodCreator addMethod = (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_REMOVED_BEANS + this.group++, Void.TYPE, new Class[]{List.class, Map.class}).setModifiers(8);
            ResultHandle currentThread = addMethod.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
            this.tccl = addMethod.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
            this.typeCache.initialize(addMethod);
            return addMethod;
        }

        @Override
        void invokeAddMethod() {
            this.targetMethod.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{List.class, Map.class}), new ResultHandle[]{this.removedBeansHandle, this.typeCacheHandle});
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressForbidden(reason="Using Type.toString() to build an informative message")
        void addComponentInternal(BeanInfo removedBean) {
            void var5_12;
            ResultHandle qualifiersHandle;
            ResultHandle removedBeansHandle = this.addMethod.getMethodParam(0);
            ResultHandle typesHandle = this.addMethod.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (org.jboss.jandex.Type type : removedBean.getTypes()) {
                if (DotNames.OBJECT.equals((Object)type.name())) continue;
                TryBlock tryBlock = this.addMethod.tryBlock();
                CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
                catchBlock.invokeStaticInterfaceMethod(MethodDescriptors.COMPONENTS_PROVIDER_UNABLE_TO_LOAD_REMOVED_BEAN_TYPE, new ResultHandle[]{catchBlock.load(type.toString()), catchBlock.getCaughtException()});
                AssignableResultHandle typeHandle = tryBlock.createVariable(Object.class);
                try {
                    Types.getTypeHandle(typeHandle, (BytecodeCreator)tryBlock, type, this.tccl, this.typeCache);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to construct the type handle for " + String.valueOf(removedBean) + ": " + e.getMessage());
                }
                tryBlock.invokeInterfaceMethod(MethodDescriptors.SET_ADD, typesHandle, new ResultHandle[]{typeHandle});
            }
            if (removedBean.hasDefaultQualifiers() || removedBean.getQualifiers().isEmpty()) {
                qualifiersHandle = this.addMethod.loadNull();
            } else {
                qualifiersHandle = this.addMethod.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (AnnotationInstance qualifierAnnotation : removedBean.getQualifiers()) {
                    if (DotNames.ANY.equals((Object)qualifierAnnotation.name())) continue;
                    BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                    if (qualifier != null) {
                        this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)this.addMethod)});
                        continue;
                    }
                    ResultHandle sharedQualifier = this.sharedQualifers.get(new AnnotationInstanceKey(qualifierAnnotation));
                    if (sharedQualifier == null) {
                        ClassInfo qualifierClass = removedBean.getDeployment().getQualifier(qualifierAnnotation.name());
                        ResultHandle qualifierHandle = ComponentsProviderGenerator.this.annotationLiterals.create((BytecodeCreator)this.addMethod, qualifierClass, qualifierAnnotation);
                        this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifierHandle});
                        this.sharedQualifers.put(new AnnotationInstanceKey(qualifierAnnotation), qualifierHandle);
                        continue;
                    }
                    this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{sharedQualifier});
                }
            }
            String description = null;
            if (removedBean.isClassBean()) {
                Object var5_8 = null;
            } else if (removedBean.isProducerField()) {
                InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_FIELD;
                description = String.valueOf(removedBean.getTarget().get().asField().declaringClass().name()) + "#" + removedBean.getTarget().get().asField().name();
            } else if (removedBean.isProducerMethod()) {
                InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_METHOD;
                description = String.valueOf(removedBean.getTarget().get().asMethod().declaringClass().name()) + "#" + removedBean.getTarget().get().asMethod().name() + "()";
            } else {
                InjectableBean.Kind kind = InjectableBean.Kind.SYNTHETIC;
            }
            ResultHandle kindHandle = var5_12 != null ? this.addMethod.readStaticField(FieldDescriptor.of(InjectableBean.Kind.class, (String)var5_12.toString(), InjectableBean.Kind.class)) : this.addMethod.loadNull();
            ResultHandle removedBeanHandle = this.addMethod.newInstance(MethodDescriptors.REMOVED_BEAN_IMPL, new ResultHandle[]{kindHandle, description != null ? this.addMethod.load(description) : this.addMethod.loadNull(), typesHandle, qualifiersHandle});
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, removedBeansHandle, new ResultHandle[]{removedBeanHandle});
        }
    }

    private static final class AnnotationInstanceKey {
        private final AnnotationInstance annotationInstance;

        AnnotationInstanceKey(AnnotationInstance annotationInstance) {
            this.annotationInstance = annotationInstance;
        }

        public int hashCode() {
            return this.annotationInstance.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationInstanceKey other = (AnnotationInstanceKey)obj;
            return this.annotationInstance.name().equals((Object)other.annotationInstance.name()) && this.annotationInstance.values().equals(other.annotationInstance.values());
        }
    }

    static abstract class ComponentAdder<T extends InjectionTargetInfo>
    implements AutoCloseable {
        private static final int GROUP_LIMIT = 30;
        protected int group = 1;
        private int componentsAdded;
        protected MethodCreator addMethod;
        protected final BytecodeCreator targetMethod;
        protected final ClassCreator componentsProvider;

        public ComponentAdder(BytecodeCreator getComponentsMethod, ClassCreator componentsProvider) {
            this.targetMethod = getComponentsMethod;
            this.componentsProvider = componentsProvider;
        }

        @Override
        public void close() {
            if (this.addMethod != null) {
                this.addMethod.returnValue(null);
            }
        }

        void addComponent(T component) {
            if (this.addMethod == null || this.componentsAdded >= this.groupLimit()) {
                if (this.addMethod != null) {
                    this.addMethod.returnValue(null);
                }
                this.componentsAdded = 0;
                this.addMethod = this.newAddMethod();
                this.invokeAddMethod();
            }
            ++this.componentsAdded;
            this.addComponentInternal(component);
        }

        abstract MethodCreator newAddMethod();

        abstract void invokeAddMethod();

        abstract void addComponentInternal(T var1);

        protected int groupLimit() {
            return 30;
        }
    }

    static class MapTypeCache
    implements Types.TypeCache {
        private ResultHandle mapHandle;

        MapTypeCache() {
        }

        @Override
        public void initialize(MethodCreator method) {
            this.mapHandle = method.getMethodParam(1);
        }

        @Override
        @SuppressForbidden(reason="Using Type.toString() to build an informative message")
        public ResultHandle get(org.jboss.jandex.Type type, BytecodeCreator bytecode) {
            return bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_GET, this.mapHandle, new ResultHandle[]{bytecode.load(type.toString())});
        }

        @Override
        @SuppressForbidden(reason="Using Type.toString() to build an informative message")
        public void put(org.jboss.jandex.Type type, ResultHandle value, BytecodeCreator bytecode) {
            bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, this.mapHandle, new ResultHandle[]{bytecode.load(type.toString()), value});
        }
    }
}

