/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.compatibility;

import java.util.Map;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.compatibility.CompatibilityResult;
import org.keycloak.compatibility.Util;
import org.keycloak.migration.ModelVersion;

public class KeycloakCompatibilityMetadataProvider
implements CompatibilityMetadataProvider {
    public static final String ID = "keycloak";
    public static final String VERSION_KEY = "version";
    private final String version;

    public KeycloakCompatibilityMetadataProvider() {
        this(Version.VERSION);
    }

    public KeycloakCompatibilityMetadataProvider(String version) {
        this.version = version;
    }

    public Map<String, String> metadata() {
        return Map.of(VERSION_KEY, this.version);
    }

    public CompatibilityResult isCompatible(Map<String, String> other) {
        CompatibilityResult equalComparison = super.isCompatible(other);
        if (!Util.isNotCompatible((CompatibilityResult)equalComparison) || !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V2)) {
            return equalComparison;
        }
        String otherVersion = other.get(VERSION_KEY);
        if (otherVersion == null) {
            return equalComparison;
        }
        boolean versionMismatch = equalComparison.incompatibleAttributes().map(erroredAttributes -> erroredAttributes.size() == 1 && ((String)erroredAttributes.iterator().next()).equals(VERSION_KEY)).orElse(false);
        if (!versionMismatch) {
            return equalComparison;
        }
        ModelVersion currentModelVersion = new ModelVersion(this.version);
        ModelVersion otherModelVersion = new ModelVersion(otherVersion);
        if (!currentModelVersion.hasSameMajorMinor(otherModelVersion)) {
            return equalComparison;
        }
        int otherMicro = otherModelVersion.getMicro();
        int currentMicro = currentModelVersion.getMicro();
        return currentMicro < otherMicro ? equalComparison : CompatibilityResult.providerCompatible((String)ID);
    }

    public String getId() {
        return ID;
    }
}

