/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this(jTree, defaultTreeCellRenderer, null);
    }

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        this.renderer = defaultTreeCellRenderer;
        this.realEditor = treeCellEditor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree(jTree);
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setTree(jTree);
        this.lastRow = n;
        this.determineOffset(jTree, object, bl, bl2, bl3, n);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        TreePath treePath = jTree.getPathForRow(n);
        this.canEdit = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = jTree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        boolean bl2 = false;
        if (eventObject != null && eventObject.getSource() instanceof JTree) {
            this.setTree((JTree)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                TreePath treePath = this.tree.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
                boolean bl3 = bl2 = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
                if (treePath != null) {
                    this.lastRow = this.tree.getRowForPath(treePath);
                    Object object = treePath.getLastPathComponent();
                    boolean bl4 = this.tree.isRowSelected(this.lastRow);
                    boolean bl5 = this.tree.isExpanded(treePath);
                    TreeModel treeModel = this.tree.getModel();
                    boolean bl6 = treeModel.isLeaf(object);
                    this.determineOffset(this.tree, object, bl4, bl5, bl6, this.lastRow);
                }
            }
        }
        if (!this.realEditor.isCellEditable(eventObject)) {
            return false;
        }
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        } else if (bl2 && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (bl) {
            this.prepareForEditing();
        }
        return bl;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.realEditor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            this.cleanupAfterEditing();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this.cleanupAfterEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return ((DefaultCellEditor)this.realEditor).getCellEditorListeners();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(JTree jTree) {
        if (this.tree != jTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = jTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() > 2 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(int n, int n2) {
        if (this.lastRow != -1 && this.tree != null) {
            Rectangle rectangle = this.tree.getRowBounds(this.lastRow);
            ComponentOrientation componentOrientation = this.tree.getComponentOrientation();
            if (componentOrientation.isLeftToRight() ? rectangle != null && n <= rectangle.x + this.offset && this.offset < rectangle.width - 5 : rectangle != null && (n >= rectangle.x + rectangle.width - this.offset + 5 || n <= rectangle.x + 5) && this.offset < rectangle.width - 5) {
                return false;
            }
        }
        return true;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.editingIcon = bl3 ? this.renderer.getLeafIcon() : (bl2 ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
        }
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new DefaultTextField(border)){

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                boolean bl = super.shouldSelectCell(eventObject);
                return bl;
            }
        };
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    private void cleanupAfterEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.realEditor != null && this.realEditor instanceof Serializable) {
            vector.addElement("realEditor");
            vector.addElement(this.realEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("realEditor")) {
            this.realEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        public void EditorContainer() {
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (DefaultTreeCellEditor.this.editingIcon != null) {
                int n3 = this.calculateIconY(DefaultTreeCellEditor.this.editingIcon);
                if (this.getComponentOrientation().isLeftToRight()) {
                    DefaultTreeCellEditor.this.editingIcon.paintIcon(this, graphics, 0, n3);
                } else {
                    DefaultTreeCellEditor.this.editingIcon.paintIcon(this, graphics, n - DefaultTreeCellEditor.this.editingIcon.getIconWidth(), n3);
                }
            }
            if ((color = DefaultTreeCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            }
            super.paint(graphics);
        }

        @Override
        public void doLayout() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this.getComponentOrientation().isLeftToRight()) {
                    DefaultTreeCellEditor.this.editingComponent.setBounds(DefaultTreeCellEditor.this.offset, 0, n - DefaultTreeCellEditor.this.offset, n2);
                } else {
                    DefaultTreeCellEditor.this.editingComponent.setBounds(0, 0, n - DefaultTreeCellEditor.this.offset, n2);
                }
            }
        }

        private int calculateIconY(Icon icon) {
            int n = icon.getIconHeight();
            int n2 = DefaultTreeCellEditor.this.editingComponent.getFontMetrics(DefaultTreeCellEditor.this.editingComponent.getFont()).getHeight();
            int n3 = n / 2 - n2 / 2;
            int n4 = Math.min(0, n3);
            int n5 = Math.max(n, n3 + n2) - n4;
            return this.getHeight() / 2 - (n4 + n5 / 2);
        }

        @Override
        public Dimension getPreferredSize() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                Dimension dimension;
                Dimension dimension2 = DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                dimension2.width += DefaultTreeCellEditor.this.offset + 5;
                Dimension dimension3 = dimension = DefaultTreeCellEditor.this.renderer != null ? DefaultTreeCellEditor.this.renderer.getPreferredSize() : null;
                if (dimension != null) {
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                }
                if (DefaultTreeCellEditor.this.editingIcon != null) {
                    dimension2.height = Math.max(dimension2.height, DefaultTreeCellEditor.this.editingIcon.getIconHeight());
                }
                dimension2.width = Math.max(dimension2.width, 100);
                return dimension2;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.setBorder(border);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container container;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (container = this.getParent()) != null && container.getFont() != null) {
                font = container.getFont();
            }
            return font;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (DefaultTreeCellEditor.this.renderer != null && DefaultTreeCellEditor.this.getFont() == null) {
                Dimension dimension2 = DefaultTreeCellEditor.this.renderer.getPreferredSize();
                dimension.height = dimension2.height;
            }
            return dimension;
        }
    }
}

