/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Alter an image with speckle (multiplicative) noise.


The speckle noise follows a gamma distribution of mean 1 and standard
deviation provided by the user. The noise is proportional to the pixel
intensity.

It can be modeled as:


$ I = I_0 \\ast G $

where $ G $ is a is a gamma distributed random variable of mean 1 and variance
proportional to the noise level:

$ G \\sim \\Gamma(\\frac{1}{\\sigma^2}, \\sigma^2) $

Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://doi.org/10.54294/vh6vbw
See:
 itk::simple::SpeckleNoise for the procedural interface

 itk::SpeckleNoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSpeckleNoiseImageFilter.h
*/
public class SpeckleNoiseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SpeckleNoiseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SpeckleNoiseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SpeckleNoiseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SpeckleNoiseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SpeckleNoiseImageFilter::~SpeckleNoiseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SpeckleNoiseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SpeckleNoiseImageFilter::SpeckleNoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SpeckleNoiseImageFilter() {
    this(SimpleITKJNI.new_SpeckleNoiseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SpeckleNoiseImageFilter::SetStandardDeviation(double StandardDeviation)

Set/Get the standard deviation of the gamma distribution. Defaults to
1.0.

*/
public  void setStandardDeviation(double StandardDeviation) {
    SimpleITKJNI.SpeckleNoiseImageFilter_setStandardDeviation(swigCPtr, this, StandardDeviation);
  }

  /**
double itk::simple::SpeckleNoiseImageFilter::GetStandardDeviation() const

Set/Get the standard deviation of the gamma distribution. Defaults to
1.0.

*/
public  double getStandardDeviation() {
    return SimpleITKJNI.SpeckleNoiseImageFilter_getStandardDeviation(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SpeckleNoiseImageFilter::SetSeed(uint32_t Seed)
*/
public  void setSeed(long Seed) {
    SimpleITKJNI.SpeckleNoiseImageFilter_setSeed(swigCPtr, this, Seed);
  }

  /**
uint32_t itk::simple::SpeckleNoiseImageFilter::GetSeed() const
*/
public  long getSeed() {
    return SimpleITKJNI.SpeckleNoiseImageFilter_getSeed(swigCPtr, this);
  }

  /**
std::string itk::simple::SpeckleNoiseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SpeckleNoiseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SpeckleNoiseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SpeckleNoiseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SpeckleNoiseImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SpeckleNoiseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
