#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-EdgifHG9sZQ3Fyc2zN8XNH
key:                  hledger-web-1.40-EdgifHG9sZQ3Fyc2zN8XNH
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  378e370ef65de1f1a4d6bd7df8913658
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-EdgifHG9sZQ3Fyc2zN8XNH
depends:
    Decimal-0.5.2-7Hvvqy46Kk3TfHnEOW5Ky
    aeson-2.1.2.1-FurzwiqHIOZ8NUBnR3RWtD base-4.17.2.1
    base64-0.4.2.4-1Iq97XHIuqx40XYl48RZUX
    blaze-html-0.9.2.0-I1J4WDLs4OzIRmd3PXN4gO
    blaze-markup-0.8.3.0-4HZGqC4yhQJ7kzfFmo57xw bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4gOYP47XUTf2S4ZStIaMwN
    clientsession-0.9.3.0-F9fKyzKxnutKJDlpfydZNE
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-E5Krv6RV3hBBPS0slvyYkr
    conduit-extra-1.3.8-24pqoJgQfAAB2FmynpaX4z containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-Isi0tZEk9Ra6WEOKtqTjmT filepath-1.4.2.2
    githash-0.1.6.3-38q1M2stlGwWMpB1FHVeO
    hjsmin-0.2.1-IYce2tQiT3ELOeYc5guz0N
    hledger-1.40-JEWd589Yhb8KLLR8mkUoRf
    hledger-lib-1.40-1nK9ZSVs8ZFCBES8EQwh1I
    hspec-2.11.0-K8tcbr0GnRpK6pvhVGiGEM
    http-client-0.7.19-7TptaWByUgGB9Q5jnOoQnY
    http-conduit-2.3.9.1-GXXHccjgKEfDNHzsgV834n
    http-types-0.12.4-GK6adOlCgtYAucedrAKKtY
    megaparsec-9.7.0-3djLYUlnjlAJjkWgXBHMlu mtl-2.2.2
    network-3.1.4.0-Lt9YSaQDSdWKRzslp3ePNQ
    safe-0.3.21-DqCLuIhxH5d2cQjqD83Qv7
    shakespeare-2.1.4-IRdfqQj2xVhLuYkwxupaYi template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-Hu6g1FPEkjd5KkhG0SWdOc
    unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-CIVco2ayREfJFzYRTWBCXQ
    wai-cors-0.2.7-LdEIeLVhEZBEzF1hR5Wh66
    wai-extra-3.1.17-EFvkiH00LqbKdu2SUpgx1K
    wai-handler-launch-3.0.3.1-5o5DCMbLQFdGVil9HYzeIA
    warp-3.3.30-6jAAQmCNqVPCrkpQFBPtLx
    yaml-0.11.11.2-J1W31KrZFIR5YtqOZiqnEf
    yesod-1.6.2.1-FN24PRZ8WrTFv5agT8OZMZ
    yesod-core-1.6.27.1-8OhbMBUQN75H3iiSNLIotT
    yesod-form-1.7.9-ZihvGH6WSLHYIhTfTb3dF
    yesod-static-1.6.1.0-JadWNMcG4s6F2vAqdnxITo
    yesod-test-1.6.23-Hpr40KtByBm3AXbb439ACT

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

