#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-EIBnJr1kbtFJwYi3NZVJtY
key:                  hledger-web-1.40-EIBnJr1kbtFJwYi3NZVJtY
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  eb6faad51e6f4b8f099a20aaa76185a0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-EIBnJr1kbtFJwYi3NZVJtY
depends:
    Decimal-0.5.2-8JDj96GTPgDCYd2osDkUm3
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf base-4.17.2.1
    base64-0.4.2.4-4UH6Y0ijluSKT44KsYCS5g
    blaze-html-0.9.2.0-E5DRDiEbjc2BhlgdqWwu1Z
    blaze-markup-0.8.3.0-Dyv3HZfUphP6FftngmQaFk bytestring-0.11.5.3
    case-insensitive-1.2.1.0-GKEaqjX3nXNEZmMRebSTRD
    clientsession-0.9.3.0-CXkSCkLaJKv90qZRwFYF35
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-FwwHGMHw6pcBHMWck7Ofs9
    conduit-extra-1.3.8-vK8Qg1gjQMD0RI2KcVvuH containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-5rwblNHIKnAJW8xVzxUUh1 filepath-1.4.2.2
    githash-0.1.6.3-IJkW43TZ4GBH6AqemX18id
    hjsmin-0.2.1-By5nf5EWE1XJq2DskBGSKg
    hledger-1.40-26HI8juXfLK7uEH6GetlcE
    hledger-lib-1.40-KhiCvuzYh9J9VKHcGndARb
    hspec-2.11.0-Hyghbe7B6AF5iIHPn5PDup
    http-client-0.7.19-LKlU3HcOEMNION0MdQYtj
    http-conduit-2.3.9.1-KYb3AREOVb2COrnBIWmjoV
    http-types-0.12.4-JotGc98QwUtHuX8PPdlxoe
    megaparsec-9.7.0-DoL2miG02BJ8XUb2sfozR5 mtl-2.2.2
    network-3.1.4.0-Be19ySMD4vC3IuDyb1IMcQ
    safe-0.3.21-6ICTSoJojhWH0zx8fOEOEW
    shakespeare-2.1.4-5qpo1171sc2770ZgwvECtF template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-GSBAQpPSas81W7oazsVVV
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-Jw3By0RvhPE8QsBvrL71Dx
    wai-cors-0.2.7-DbSV6gjVc1qCE4NhpqdKqO
    wai-extra-3.1.17-IcD7nw8NdejnVPbndikWQ
    wai-handler-launch-3.0.3.1-yWr0BW1nsLKi0WmoBmyFB
    warp-3.3.30-EhWqzNAs6m6FYN5Vdmx4dq
    yaml-0.11.11.2-E2y2ob5lfUes8QJFxXIpl
    yesod-1.6.2.1-D9nd6ucQeYy9Ga19OmS5xF
    yesod-core-1.6.27.1-AvkgIJCPGp4EoSYdWjMPG4
    yesod-form-1.7.9-EEpedk0MRcNBpvLxhKBxxo
    yesod-static-1.6.1.0-B8TSY1XYvAMQsGwsEi9gi
    yesod-test-1.6.23-FJqDrV3AifmBWP5E9qvKsq

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

