#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.40
visibility:           public
id:                   hledger-1.40-1tgky5pinib5iKy0CsbDdz
key:                  hledger-1.40-1tgky5pinib5iKy0CsbDdz
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  fad5a27b6cfc94018b69737a2c29a735
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.40-1tgky5pinib5iKy0CsbDdz
depends:
    Decimal-0.5.2-AmxrYKF6eEd399LgGvC3L2
    Diff-0.4.1-GcqdD78fbkMBZft0adAeUr
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 extra-1.7.16-EVqIvjfjup2KjWh1SyzBng
    filepath-1.4.2.2 githash-0.1.6.3-HmqZIPTawV368mHir3XT8u
    hashable-1.4.4.0-85lkkmOSRZHDIzkr9EkKNp haskeline-0.8.2
    hledger-lib-1.40-1Xl7je7PL8z3tpRvMVEZTK
    lucid-2.11.20250303-1Ts7BK1H6a42k8HYsSTcB3
    math-functions-0.3.4.4-3BdpCnCVqNQCjzMwic3lbm
    megaparsec-9.7.0-AMbJQB9BzBxf81g5ZS6Op
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-Ad5TdY6WlXxFUwxGz6iFnw
    safe-0.3.21-4A1yMugax9JCQWzW2mE78Z
    shakespeare-2.1.3-GXia45KV4K5AqDlFAccbVH
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-FRQtZsdenVIBoQGCChJ79f
    temporary-1.3-21yt0VJKXh7mDWSuXOVeh terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-CsWXxjNAzl44Xyjod5JYRZ time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    utility-ht-0.0.17.2-CYyoXxonMueGvk8a9wpDIW
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

