#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-LPaaVqbZgZiKfvdKvW0YEX
key:                  trifecta-2.1.4-LPaaVqbZgZiKfvdKvW0YEX
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  6d7e4062f0be0024dcb9700eb63579b7
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-LPaaVqbZgZiKfvdKvW0YEX
depends:
    ansi-terminal-1.0.2-JhmKbae07oX7bHm2tOBr0F array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-7dSTOUNuoqbGnV7oOmLUW6
    blaze-html-0.9.2.0-9XbYd3BuaoOCWGJeBuMwxI
    blaze-markup-0.8.3.0-6QvbZAZCbFl1UYXsobZak bytestring-0.11.5.3
    charset-0.3.12-CxPuclzHnjt2SBNg9PmtqF
    comonad-5.0.9-Fgzi2ELWZ8DIst9tSOthfF containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-5bwCRqPSPONFRvZK1Xdkww
    ghc-prim-0.9.1 hashable-1.4.4.0-92QHxum7zjW25fH5Mdbvto
    indexed-traversable-0.1.4-HmCeTJ1cz14DZudjUkSqsc
    lens-5.3.1-LjfZJ7QVgZYGOTr5fwppHy mtl-2.2.2
    parsers-0.12.12-80zmcniTaRb1ht9Xk8Ttlw
    prettyprinter-1.7.1-27Ta3g9m3VQHgx6FjDiyXu
    prettyprinter-ansi-terminal-1.1.3-DxfNV5472scK2uuBICYXIT
    profunctors-5.6.3-7zRtOI4ZksVJphoKXd1Kes
    reducers-3.12.5-JPTDUbxfp1A5OFREIrMavz transformers-0.5.6.2
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

