#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-HQMusMy6MWf5Mr7i0qup9K
key:                  trifecta-2.1.4-HQMusMy6MWf5Mr7i0qup9K
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  0e018e929e26693a299bf1bc68b0f4a6
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-HQMusMy6MWf5Mr7i0qup9K
depends:
    ansi-terminal-1.0.2-1WMmnSFsRadEUq8BUHK73i array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-EYzzAuOKf5mlUrLaPwbAW
    blaze-html-0.9.2.0-E5DRDiEbjc2BhlgdqWwu1Z
    blaze-markup-0.8.3.0-Dyv3HZfUphP6FftngmQaFk bytestring-0.11.5.3
    charset-0.3.12-4RbaF7JHH3PEr4lBVvphks
    comonad-5.0.9-7ovkNyXx8QjFNTcyXoMDqs containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-CxmkMtbkhuwBWxgehwAVeR
    ghc-prim-0.9.1 hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    indexed-traversable-0.1.4-LyeF3yLPY26FCcc6uHtQva
    lens-5.3.1-L3T26fDKV8KAh84K9wN8lF mtl-2.2.2
    parsers-0.12.12-7LaBP4SOVfQ2EPeolO2UXt
    prettyprinter-1.7.1-GW24MvTJNAcBiqvxAdyJJ2
    prettyprinter-ansi-terminal-1.1.3-1FYm69oHtbE2eHLM7mvKdL
    profunctors-5.6.3-63mQtfUXOTH6K8o94A7vA
    reducers-3.12.5-2la3OGHiT1JJAZafmTNWN3 transformers-0.5.6.2
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

