#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   text-icu
version:                0.8.0.5
visibility:             public
id:                     text-icu-0.8.0.5-Ha1QpUQWpmlJtW9xd9Tkj0
key:                    text-icu-0.8.0.5-Ha1QpUQWpmlJtW9xd9Tkj0
license:                BSD-3-Clause
copyright:              2009-2015 Bryan O'\''Sullivan
maintainer:             Vladimir Shabanov <dev@vshabanov.com>
homepage:               https://github.com/haskell/text-icu
synopsis:               Bindings to the ICU library
description:
    Haskell bindings to the International Components for Unicode (ICU)
    libraries.  These libraries provide robust and full-featured Unicode
    services on a wide variety of platforms.

    Features include:

    * Both pure and impure bindings, to allow for fine control over efficiency
    and ease of use.

    * Breaking of strings on character, word, sentence, and line boundaries.

    * Access to the Unicode Character Database (UCD) of character metadata.

    * String collation functions, for locales where the conventions for
    lexicographic ordering differ from the simple numeric ordering of
    character codes.

    * Character set conversion functions, allowing conversion between
    Unicode and over 220 character encodings.

    * Unicode normalization.  (When implementations keep strings in a
    normalized form, they can be assured that equivalent strings have a
    unique binary representation.)

    * Regular expression search and replace.

    * Security checks for visually confusable (spoofable) strings.

    * Bidirectional Unicode algorithm

    * Calendar objects holding dates and times.

    * Number and calendar formatting.

category:               Data, Text
abi:                    785c6b424ae9839affdba50d965f91b1
exposed:                True
exposed-modules:
    Data.Text.ICU Data.Text.ICU.BiDi Data.Text.ICU.Break
    Data.Text.ICU.Calendar Data.Text.ICU.Char
    Data.Text.ICU.CharsetDetection Data.Text.ICU.Collate
    Data.Text.ICU.Convert Data.Text.ICU.DateFormatter
    Data.Text.ICU.Error Data.Text.ICU.Locale Data.Text.ICU.Normalize
    Data.Text.ICU.Normalize2 Data.Text.ICU.Number
    Data.Text.ICU.NumberFormatter Data.Text.ICU.Regex
    Data.Text.ICU.Shape Data.Text.ICU.Spoof Data.Text.ICU.Types

hidden-modules:
    Data.Text.ICU.BiDi.Internal Data.Text.ICU.BitMask
    Data.Text.ICU.Break.Pure Data.Text.ICU.Break.Types
    Data.Text.ICU.CharsetDetection.Internal
    Data.Text.ICU.Collate.Internal Data.Text.ICU.Collate.Pure
    Data.Text.ICU.Number.Internal Data.Text.ICU.Convert.Internal
    Data.Text.ICU.Enumerator Data.Text.ICU.Error.Internal
    Data.Text.ICU.Internal Data.Text.ICU.Iterator
    Data.Text.ICU.Normalize.Internal Data.Text.ICU.Regex.Internal
    Data.Text.ICU.Regex.Pure Data.Text.ICU.Spoof.Internal
    Data.Text.ICU.Spoof.Pure Data.Text.ICU.Text

import-dirs:            /usr/lib/ghc-9.4.8/site-local/text-icu-0.8.0.5
library-dirs:           /usr/lib/ghc-9.4.8/site-local/text-icu-0.8.0.5
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/text-icu-0.8.0.5
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-text-icu
hs-libraries:           HStext-icu-0.8.0.5-Ha1QpUQWpmlJtW9xd9Tkj0
extra-libraries:        icuuc icui18n icudata icui18n
extra-libraries-static: icui18n icuuc icudata pthread m
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 text-2.0.2
    time-1.12.2

haddock-interfaces:     /usr/share/doc/haskell-text-icu/html/text-icu.haddock
haddock-html:           /usr/share/doc/haskell-text-icu/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

