#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 microspec
version:              0.2.1.3
visibility:           public
id:                   microspec-0.2.1.3-1ho9gKq2ynP3YSEXCiE4WS
key:                  microspec-0.2.1.3-1ho9gKq2ynP3YSEXCiE4WS
license:              BSD-3-Clause
maintainer:           Tom Murphy
author:               Tom Murphy
stability:            experimental
synopsis:             Tiny QuickCheck test library with minimal dependencies
description:
    A tiny (1 module, <500 lines) property-based (and unit) testing library with minimal dependencies.

    Instead of reinventing the wheel (<https://xkcd.com/927>), we use a
    RSpec/HSpec-like DSL and run tests with QuickCheck.

    For many use-cases, microspec is a drop-in replacement for hspec.

    > import Test.Microspec
    >
    > main :: IO ()
    > main = microspec $ do
    >    describe "replicate" $ do
    >       it "doubles with 2" $
    >          replicate 2 '\''x'\'' === "xx"
    >       it "creates a list of the right size" $
    >          \(Positive n) -> length (replicate n '\''x'\'') === n
    >
    >    describe "reverse" $ do
    >       it "reverse . reverse === id" $ \l ->
    >          reverse (reverse l) === (l :: [Int])
    >
    >    describe "tail" $
    >       it "length is -1" $ \(NonEmpty l) ->
    >          length (tail l :: [Int]) === length l - 1
    >
    >    describe "solve the halting problem" $
    >       pending

category:             Test, Testing
abi:                  bb84769a5c79f3920018d4cc8bb1625d
exposed:              True
exposed-modules:      Test.Microspec
import-dirs:          /usr/lib/ghc-9.4.8/site-local/microspec-0.2.1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/microspec-0.2.1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/microspec-0.2.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-microspec
hs-libraries:         HSmicrospec-0.2.1.3-1ho9gKq2ynP3YSEXCiE4WS
depends:
    QuickCheck-2.14.3-3S3WOBL6rHa3L0CMYI1WVh base-4.17.2.1 time-1.12.2

haddock-interfaces:   /usr/share/doc/haskell-microspec/html/microspec.haddock
haddock-html:         /usr/share/doc/haskell-microspec/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

