#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lens
version:              5.3.1
visibility:           public
id:                   lens-5.3.1-L3T26fDKV8KAh84K9wN8lF
key:                  lens-5.3.1-L3T26fDKV8KAh84K9wN8lF
license:              BSD-2-Clause
copyright:            Copyright (C) 2012-2016 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/lens/
synopsis:             Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.

    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.

    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.

    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.

    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.

    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.

    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.

    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.

    /Lenses, Folds and Traversals/

    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:


    <<http://i.imgur.com/ALlbPRa.png>>

    <https://raw.githubusercontent.com/ekmett/lens/master/images/Hierarchy.png (Local Copy)>

    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.

    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).

    For instance:

    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.

    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.

    /Minimizing Dependencies/

    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.

    /e.g./ for a data type:

    > data Foo a = Foo Int Int a

    You can define lenses such as

    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)

    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)

    without the need to use any type that isn'\''t already defined in the @Prelude@.

    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':

    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c

    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).

category:             Data, Lenses, Generics
abi:                  1ae8695f64a088804b3b5ca4808eab32
exposed:              True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Context Control.Lens.Internal.Deque
    Control.Lens.Internal.Doctest Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Profunctor
    Control.Lens.Internal.Review Control.Lens.Internal.Setter
    Control.Lens.Internal.TH Control.Lens.Internal.Zoom
    Control.Lens.Iso Control.Lens.Lens Control.Lens.Level
    Control.Lens.Operators Control.Lens.Plated Control.Lens.Prism
    Control.Lens.Profunctor Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Unsound
    Control.Lens.Wrapped Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    Numeric.Natural.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens

hidden-modules:       Control.Lens.Internal.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/lens-5.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lens-5.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lens-5.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lens
hs-libraries:         HSlens-5.3.1-L3T26fDKV8KAh84K9wN8lF
depends:
    array-0.5.4.0 assoc-1.1.1-ECHUyXuI4DU7saXDIs2gf3 base-4.17.2.1
    base-orphans-0.9.2-LQGxCYkAh7aFvJ0uEheUzK
    bifunctors-5.6.2-5yBt2VZqrV2LUbi3Oa675Z bytestring-0.11.5.3
    call-stack-0.4.0-GLZYnk9HL8J8EgKDjlcntK
    comonad-5.0.9-7ovkNyXx8QjFNTcyXoMDqs containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    distributive-0.6.2.1-FmGbMm7Zg0XKdpzWDlcElj exceptions-0.10.5
    filepath-1.4.2.2 free-5.2-1VadUHgfoPu9wU2v7YEGOG ghc-prim-0.9.1
    hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    indexed-traversable-0.1.4-LyeF3yLPY26FCcc6uHtQva
    indexed-traversable-instances-0.1.2-5PEjsSGwM9x9Nqd5eMJHfr
    kan-extensions-5.2.7-IZ8l155Co8K2v4OSOt29Hs mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    profunctors-5.6.3-63mQtfUXOTH6K8o94A7vA
    reflection-2.1.9-Fqnm9dXtDilBSIoQe8KhP3
    semigroupoids-6.0.1-6UDNhnrCcmB8qcD4TESfdi
    strict-0.5-4M5O4U7hGB2CIOCmI2n6XA
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-A1iF20SJCyz2l4WDICkAUH transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A

haddock-interfaces:   /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html:         /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

