#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 json-ast
version:              0.3.2
visibility:           public
id:                   json-ast-0.3.2-E4MGgJhv9BqFzWDu3E7Tgq
key:                  json-ast-0.3.2-E4MGgJhv9BqFzWDu3E7Tgq
license:              MIT
copyright:            (c) 2016, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/json-ast 
synopsis:             Universal JSON AST datastructure
description:
    This library provides only a data-type representing the JSON value tree.
    It is intended to be used as a shared data-type by all kinds of JSON libraries.
    Same as we have the \"xml-types\" package for libraries dealing with XML.

    Now, since the \"aeson\" @Value@ has been serving this purpose for years,
    we'\''ve intentionally made this type representationally identical to it,
    making it possible to convert between them at 0 runtime cost.
    This means that we can use those types interchangeably,
    making it possible to gradually migrate.

    ===Why displace the \"aeson\" @Value@?

    1. To boost the competition between JSON libraries.
    Instead of nudging the community to implement its ideas by patching \"aeson\".
    After all, competition is the driving force of evolution and hence progress.

    2. Due to so much patching already happening to \"aeson\",
    its loss of focus, some questionable design and
    strive for backwards compatibility, it'\''s becoming bloated.
    IOW, it'\''s trying to be "everything JSON" but with no careful design or plan and
    it'\''s tied by its past.
    With these restrictions it'\''s impossible for \"aeson\" to ever become a polished
    library.

abi:                  e31fb2493729751738c0365cda94b5ff
exposed:              True
exposed-modules:      JSONAST
import-dirs:          /usr/lib/ghc-9.4.8/site-local/json-ast-0.3.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/json-ast-0.3.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/json-ast-0.3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-json-ast
hs-libraries:         HSjson-ast-0.3.2-E4MGgJhv9BqFzWDu3E7Tgq
depends:
    base-4.17.2.1 scientific-0.3.8.0-FY8DXpomWvN257bBgIbNZf text-2.0.2
    unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    vector-0.13.2.0-7SsYBYYt4xiG1AFztZAEHX

haddock-interfaces:   /usr/share/doc/haskell-json-ast/html/json-ast.haddock
haddock-html:         /usr/share/doc/haskell-json-ast/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

