#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-I3hUcd4p9LaIRZGe8C9Q85
key:                  jose-0.10-I3hUcd4p9LaIRZGe8C9Q85
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  3c040745ff8e8b7351f43ce756a0b0db
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-I3hUcd4p9LaIRZGe8C9Q85
depends:
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 concise-0.1.0.1-D5wYCwAJqIe3xm7Ni1jrz8
    containers-0.6.7 cryptonite-0.30-4NlwkgHWOQIHuimaNuJwdH
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-time-0.4.0.0-LPoHPY62S3DIdducY8Hb6X mtl-2.2.2
    network-uri-2.6.4.2-37qi4fIAhTC8owHWseusWs
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    x509-1.7.7-JPocz0J9MVt6c5Vo5X4uwM

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

