#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTTP
version:              4000.4.1
visibility:           public
id:                   HTTP-4000.4.1-KuyjCR7HUT5I1dJUpIuPzp
key:                  HTTP-4000.4.1-KuyjCR7HUT5I1dJUpIuPzp
license:              BSD-3-Clause
maintainer:           Ganesh Sittampalam <ganesh@earth.li>
author:               Warrick Gray <warrick.gray@hotmail.com>
homepage:             https://github.com/haskell/HTTP
synopsis:             A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.

    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.

    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).

    Here'\''s an example use:

    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))

    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:

    * <http://hackage.haskell.org/package/http-streams http-streams>

    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)

    * <http://hackage.haskell.org/package/req req>

    * <http://hackage.haskell.org/package/wreq wreq>

category:             Network
abi:                  b6acf1c2eac2b908ce2989c7a2e450e1
exposed:              True
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP

hidden-modules:
    Network.HTTP.Base64 Network.HTTP.MD5Aux Network.HTTP.Utils
    Paths_HTTP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTTP-4000.4.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTTP-4000.4.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTTP-4000.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http
hs-libraries:         HSHTTP-4000.4.1-KuyjCR7HUT5I1dJUpIuPzp
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3 mtl-2.2.2
    network-3.1.4.0-Ds1jGwhI6OBB7cQ3449UkE
    network-uri-2.6.4.2-BUyFg1hFmM35dSD0y76h3W parsec-3.1.16.1
    time-1.12.2 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html:         /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

