#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hourglass
version:              0.2.12
visibility:           public
id:                   hourglass-0.2.12-IqTy0CGbgai7bpcF3tMAb
key:                  hourglass-0.2.12-IqTy0CGbgai7bpcF3tMAb
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-hourglass
synopsis:             simple performant time related library
description:
    Simple time library focusing on simple but powerful and performant API

    The backbone of the library are the Timeable and Time type classes.

    Each Timeable instances can be converted to type that has a Time instances,
    and thus are different representations of current time.

category:             Time
abi:                  0607fdecb827831331495c4bec15a5fc
exposed:              True
exposed-modules:
    Data.Hourglass Data.Hourglass.Compat Data.Hourglass.Epoch
    Data.Hourglass.Types System.Hourglass Time.Compat Time.System
    Time.Types

hidden-modules:
    Data.Hourglass.Time Data.Hourglass.Format Data.Hourglass.Diff
    Data.Hourglass.Local Data.Hourglass.Calendar Data.Hourglass.Zone
    Data.Hourglass.Internal Data.Hourglass.Utils
    Data.Hourglass.Internal.Unix

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hourglass-0.2.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hourglass-0.2.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hourglass-0.2.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hourglass
hs-libraries:         HShourglass-0.2.12-IqTy0CGbgai7bpcF3tMAb
depends:              base-4.17.2.1 deepseq-1.4.8.0
haddock-interfaces:   /usr/share/doc/haskell-hourglass/html/hourglass.haddock
haddock-html:         /usr/share/doc/haskell-hourglass/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

