#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-Cyg3e3EmCm37R9xfVNVEs0
key:                  hOpenPGP-2.10.1-Cyg3e3EmCm37R9xfVNVEs0
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  c07317c92b7f81f9694b97a94befc013
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-Cyg3e3EmCm37R9xfVNVEs0
depends:
    aeson-2.1.2.1-8PRfz0Kg6mwK2TOn7o5BkY
    asn1-encoding-0.9.6-IUZeukKlfq34W43UAxzOEF
    attoparsec-0.14.4-JY3WRVtwl2HEigkrgC0fwc base-4.17.2.1
    base16-bytestring-1.0.2.0-FQGERq7xPf6LrZ8CrB0oGn
    bifunctors-5.6.2-1ipJ5MvX1ny4cCMu0E9Jrs binary-0.8.9.1
    binary-conduit-1.3.1-12kdDwcogeE49BspChTJjX bytestring-0.11.5.3
    bz2-1.0.1.1-3oLbUGdwbTg9Z18mGMRokH
    conduit-1.3.6.1-JOByYHd4UhSLHkAURX473h
    conduit-extra-1.3.8-6krltdaujp79VudWk7QgcA containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-7S9lnDIkLEuErwGoGWVf19
    errors-2.3.0-BIrKKDqlEdGFK0OgtbPFOP
    hashable-1.4.4.0-DGEtQXeqhKmCCbhJMtBsUM
    incremental-parser-0.5.1-L8koXMivOlr5GCZUhOUx8f
    ixset-typed-0.5.1.0-Al35BXANwtMJ7yH8MMxMkg
    lens-5.3.1-2DX9LGrXssTCTVwrYJIT9U
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-KCWNlmsAWh8C1z4az19KdT
    openpgp-asciiarmor-0.1.2-B40Q9iabaxi9neM7jKxmoq
    prettyprinter-1.7.1-HbDxqL4Ls6KKY7PcGY4CHy
    resourcet-1.2.6-EBGYfS72ufv4niGJn1xKwD
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-8Q4WKXtMGLf6eJrIPiNhPJ
    zlib-0.7.0.0-JbjVQGZKr912ZiOqa2LP90

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

