#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-2ja3NvfLOCQpQJvJGyrly
key:                  hOpenPGP-2.10.1-2ja3NvfLOCQpQJvJGyrly
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  601e4ce48dc31ab7198232fe2bfd3ca1
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-2ja3NvfLOCQpQJvJGyrly
depends:
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf
    asn1-encoding-0.9.6-6bILbVjk4mj9mjwSmtzJsS
    attoparsec-0.14.4-7XWZ3nsZOGKJDEorzXp6qF base-4.17.2.1
    base16-bytestring-1.0.2.0-1bEkwAvKVlC52PGjoO72jZ
    bifunctors-5.6.2-5yBt2VZqrV2LUbi3Oa675Z binary-0.8.9.1
    binary-conduit-1.3.1-6vKaDzYs9807pxVMvxt2lU bytestring-0.11.5.3
    bz2-1.0.1.1-KLM1kt3z5g7L7q9mGf5br8
    conduit-1.3.6.1-FwwHGMHw6pcBHMWck7Ofs9
    conduit-extra-1.3.8-vK8Qg1gjQMD0RI2KcVvuH containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-Kg4v6mjTpaO8L2gZHA2PVC
    errors-2.3.0-IX8tbfadCsKCAcCnFNwzCk
    hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    incremental-parser-0.5.1-Y8mira497f3bPYHBQa1Tw
    ixset-typed-0.5.1.0-F2zLE4dwGiw4TJNTxzg6hZ
    lens-5.3.1-L3T26fDKV8KAh84K9wN8lF
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-CScpRPfTOboAxTStoroPUs
    openpgp-asciiarmor-0.1.2-F0M3QJO81TMEluJfxCHyz6
    prettyprinter-1.7.1-GW24MvTJNAcBiqvxAdyJJ2
    resourcet-1.2.6-Jhk5QcgHinY7iAJawXyIYk
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    zlib-0.7.0.0-JTYJvh7bdef7shhdY83ka1

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

