#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 fingertree
version:              0.1.6.2
visibility:           public
id:                   fingertree-0.1.6.2-KNEOMYCBy9RJydYWYEiZ90
key:                  fingertree-0.1.6.2-KNEOMYCBy9RJydYWYEiZ90
license:              BSD-3-Clause
copyright:            (c) 2006 Ross Paterson, Ralf Hinze
maintainer:           Ross Paterson <R.Paterson@city.ac.uk>
synopsis:             Generic finger-tree structure, with example instances
description:
    A general sequence representation with arbitrary
    annotations, for use as a base for implementations of
    various collection types, with examples, as described
    in section 4 of

    * Ralf Hinze and Ross Paterson,
    \"Finger trees: a simple general-purpose data structure\",
    /Journal of Functional Programming/ 16:2 (2006) pp 197-217.
    <https://staff.city.ac.uk/~ross/papers/FingerTree.html>

    For a tuned sequence type, see @Data.Sequence@ in the
    @containers@ package, which is a specialization of
    this structure.

category:             Data Structures
abi:                  779a3fc2bb885e8b0a28fa17874276e4
exposed:              True
exposed-modules:
    Data.FingerTree Data.IntervalMap.FingerTree
    Data.PriorityQueue.FingerTree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/fingertree-0.1.6.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/fingertree-0.1.6.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/fingertree-0.1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-fingertree
hs-libraries:         HSfingertree-0.1.6.2-KNEOMYCBy9RJydYWYEiZ90
depends:              base-4.17.2.1 deepseq-1.4.8.0
haddock-interfaces:   /usr/share/doc/haskell-fingertree/html/fingertree.haddock
haddock-html:         /usr/share/doc/haskell-fingertree/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

