#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.3
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.3-3JEipUvp14EHYnj9mpEOvu-haskell-ci-internal

key:
    haskell-ci-0.16.3-3JEipUvp14EHYnj9mpEOvu-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  23e8c42c18a5cf836ec5213e40748225
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.3-3JEipUvp14EHYnj9mpEOvu-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.5-Cc53KENinWgGNCBKvMXfJ3
    ShellCheck-0.11.0-Id7zkJOB1xiG3ffKHkOIbi
    aeson-2.1.2.1-8PRfz0Kg6mwK2TOn7o5BkY
    attoparsec-0.14.4-JY3WRVtwl2HEigkrgC0fwc base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp
    base16-bytestring-1.0.2.0-FQGERq7xPf6LrZ8CrB0oGn binary-0.8.9.1
    bytestring-0.11.5.3 cabal-install-parsers-0.6-wmelukzN60J3ue27Frwmz
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-83ZxZYIoOaJB9xrlNOjKJi deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-6f7QMxxVa65AkebUdOFXN5
    indexed-traversable-instances-0.1.2-5DIpBurKD2iAmxB9C1dCu1
    ini-0.4.2-KC0HngtebiLCYM6LB9OhtR
    lattices-2.2.1-C9lI6B5GaCzIb8MRm0WgLX mtl-2.2.2
    network-uri-2.6.4.2-KCWNlmsAWh8C1z4az19KdT
    optparse-applicative-0.18.1.0-HXqK0jqM8QFKV9KXEnSs2h
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-6YbEjLKDNjc6IO1VlPHH38 text-2.0.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-8Q4WKXtMGLf6eJrIPiNhPJ
    zinza-0.2-4Eooxzh6Yq9CGRESkbjrkA

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

