#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.3
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.3-LgBkHqd4Y9pFzwgf33Wsec-haskell-ci-internal

key:
    haskell-ci-0.16.3-LgBkHqd4Y9pFzwgf33Wsec-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  fa9142ff7eb4d2026f58bb30b803296e
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.3-LgBkHqd4Y9pFzwgf33Wsec-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.5-H9YqZJwW6Z2Livl5QGjNDO
    ShellCheck-0.11.0-LGwKB32TaMS35BXflFQCBR
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
    attoparsec-0.14.4-EuJHdCyQx9qFeM6j3QZsTf base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp
    base16-bytestring-1.0.2.0-77LKTpx3RBTESMCNCprD68 binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6-Ii7bnLvUyQEHT5f1596gbX containers-0.6.7
    cryptohash-sha256-0.11.102.1-8JYKQGKn9YZ6qg6x0En4hs deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-HmCeTJ1cz14DZudjUkSqsc
    indexed-traversable-instances-0.1.2-HmbntLbj9S215mxcucKEWx
    ini-0.4.2-1QZoujHDAVWJqj3s3P6Osb
    lattices-2.2.1-D5yXsECX46qJYtEEM2Sb79 mtl-2.2.2
    network-uri-2.6.4.2-BUyFg1hFmM35dSD0y76h3W
    optparse-applicative-0.18.1.0-7a3VGVGHpDh9ZqkU0lCBOm
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-AgnyQJqoH2tBVE9T1YksW9 text-2.0.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    zinza-0.2-9E8kGqMrkhV9FUPf34AESD

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

