#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-CR6jd5dsJdR4XIMlcu70sB
key:                  glirc-2.40.1-CR6jd5dsJdR4XIMlcu70sB
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  18ae2ed8f0b31e58fd3e0c9469a9b018
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-CR6jd5dsJdR4XIMlcu70sB
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-Iw1EFh3wZS8LcoBYdzqrEa
    async-2.2.5-BcqMz9kSLpQJiwvDzQjiwa
    attoparsec-0.14.4-FKpKWqwLteZDlwxf33yCFk base-4.17.2.1
    base64-bytestring-1.2.1.0-36j4xjYGwYUKFZDPcQTnk0
    bytestring-0.11.5.3 config-schema-1.3.0.0-2RqO2lXgCKO5MuVaCv5P2y
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-74ppnQMgC3LCeDMO7FMrV8 directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-3rsNvYqTHxIBI27gtRd9G
    githash-0.1.6.3-1AgjSFyXmnbIU0GC9an0FJ
    hashable-1.4.4.0-KHdv63hvW7JkoOGsLWKac
    hookup-0.8-7e624D1BilDCzbnPhv2OoH
    irc-core-2.12-ASJjnBDvEXO3veD22aplRL
    kan-extensions-5.2.7-C178kYNXtLlHqtNIQre2Q8
    lens-5.3.1-6s7OGBiqW0t1WJAI91dKgc
    network-3.1.4.0-Aot7Hsnd3no7HIoU7vrrpP
    psqueues-0.2.8.2-7RcNZ1ExpG4yB6rQOBZqj
    random-1.2.1.3-8yAn85BRVsALc4v1F70S7L
    regex-tdfa-1.3.2.4-It8kSvUca7pIUIDpZynqfd
    semigroupoids-6.0.1-4JTptGndUKqJAldIKBf7gy
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-Kk0VKYhQSqhJ29FAbLnyft
    unix-2.7.3 unordered-containers-0.2.20-1i1FNKzvn6TI2R1AzcNrcz
    vector-0.13.2.0-FNdsFzivQrc5gVfjRMxS7n
    vty-6.2-FRnfDo2xxnWL0uInxiUZOM

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

