#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-I0yShNgndWd4DWygvvtIF7
key:                  gitit-0.15.1.2-I0yShNgndWd4DWygvvtIF7
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  57aa976fa432248331e77bb964f9c63e
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-I0yShNgndWd4DWygvvtIF7
depends:
    HStringTemplate-0.8.8-2Qhx0Hrv1oWLbO5kDzpVF5
    HTTP-4000.4.1-8eWOBVuGRcwFzWqphjtg9S
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-FurzwiqHIOZ8NUBnR3RWtD base-4.17.2.1
    base64-bytestring-1.2.1.0-L7UKPnwJMRGuk8q2bdjAR
    blaze-html-0.9.2.0-I1J4WDLs4OzIRmd3PXN4gO bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-FskE7341VSL5sLdTxILYqp
    feed-1.3.2.1-IcxNuls2iDfAKhYgVBY2wH filepath-1.4.2.2
    filestore-0.6.5.1-BKx4C7YC3jM9a5lMiQ4Bjp ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-H01O1zb5HWR4QD6EJ2vH5t
    hoauth2-2.11.0-Jabo1YnizfOCwsItU28ovt
    hslogger-1.3.1.2-JDI6yKw8w4kJF6kL33MQ8y
    http-client-tls-0.3.6.4-3HdL8pscJo22qAm0LdYAWU
    http-conduit-2.3.9.1-GXXHccjgKEfDNHzsgV834n
    json-0.10-HQ53o9xwf9lL3bC3dID88c mtl-2.2.2
    network-3.1.4.0-Lt9YSaQDSdWKRzslp3ePNQ
    network-bsd-2.8.1.0-G4b5HvUF1qkJMT9G7JePmF
    network-uri-2.6.4.2-DUv5vSA1kyG9zefYf8rGu8
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-LOaISt7QoDfDteC0kS4DE0
    pandoc-types-1.23.1-4KWJagB0r1LGGZKa0wt3cP parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-BGGJ1HKj6xm3DkCP4JY8iZ
    recaptcha-0.1.0.4-EMZ8OA8SVbr1fH2W6A7tbH
    safe-0.3.21-DqCLuIhxH5d2cQjqD83Qv7
    skylighting-0.14.2-K8wUQcefIaiLOoJUv1tvsB
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-LBhYOmNvCTD9nmTNYbjxYb
    tagsoup-0.14.8-CwesdMDbS4j3vbhEVVRuDv
    temporary-1.3-EG3p5EUtjekFmwlm9f2IPf text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-7MAZ1fX0PhuAvje2xldBx7
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-8czFtbZqpi3AyOuvGDHcxt xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-662vRXPQt9567cW4eCDvQa
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-LCBI9kunEzd8MEgVb9AfyU
    zlib-0.7.0.0-4FpdxOqQBdK9wzg7bW7HW9

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

