/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.api;

import java.awt.ComponentOrientation;
import java.io.File;

public enum TextWritingDirection {
    LEFT_TO_RIGHT(ComponentOrientation.LEFT_TO_RIGHT, '\u202d', '\u202a', '\u2066', '\u200e'),
    RIGHT_TO_LEFT(ComponentOrientation.RIGHT_TO_LEFT, '\u202e', '\u202b', '\u2067', '\u200f');

    private static final char popDirection = '\u202c';
    private static final char popIsolation = '\u2069';
    private static final String separator;
    private static final String separatorReplacement;
    public final ComponentOrientation componentOrientation;
    private final char embedded;
    private final char overwritten;
    private final char isolated;
    private final char mark;
    public static final TextWritingDirection DEFAULT;

    public static boolean containsRTL(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            byte dir = Character.getDirectionality(ch);
            if (dir != 1 && dir != 2 && dir != 16 && dir != 17) continue;
            return true;
        }
        return false;
    }

    private TextWritingDirection(ComponentOrientation componentOrientation, char overwritten, char embedded, char isolated, char mark) {
        this.componentOrientation = componentOrientation;
        this.overwritten = overwritten;
        this.embedded = embedded;
        this.isolated = isolated;
        this.mark = mark;
    }

    public String overwritten(String text) {
        return this.addControlCharacters(text, this.overwritten, '\u202c');
    }

    public String embedded(String text) {
        return this.addControlCharacters(text, this.embedded, '\u202c');
    }

    public String isolatePathSeparators(String path) {
        return TextWritingDirection.containsRTL(path) ? this.embedded(path.replace(separator, separatorReplacement)) : path;
    }

    public String isolated(String text) {
        return this.addControlCharacters(text, this.isolated, '\u2069');
    }

    public String marked(String text) {
        return new StringBuilder(text.length() + 1).append(this.mark).append(text).toString();
    }

    private String addControlCharacters(String text, char start, char end) {
        return new StringBuilder(text.length() + 3).append(start).append(text).append(end).append(this.mark).toString();
    }

    static {
        separator = File.separator;
        separatorReplacement = LEFT_TO_RIGHT.isolated(File.separator);
        DEFAULT = LEFT_TO_RIGHT;
    }
}

