/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;

abstract class ControlGroupChangeListener
implements PropertyChangeListener {
    private final Collection<IPropertyControl> properties;
    private final RevertingProperty mSet;
    protected boolean internalChange;

    public ControlGroupChangeListener(RevertingProperty mSet, IPropertyControl ... properties) {
        this.mSet = mSet;
        this.properties = Arrays.asList(properties);
    }

    abstract void applyValue(boolean var1, NodeModel var2, PropertyChangeEvent var3);

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled;
        if (this.internalChange) {
            return;
        }
        if (evt.getSource().equals((Object)this.mSet)) {
            enabled = this.mSet.getBooleanValue();
        } else {
            assert (this.properties.contains(evt.getSource()));
            enabled = true;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Set nodes = selection.getSelection();
        if (enabled) {
            this.internalChange = true;
        }
        for (NodeModel node : nodes) {
            this.applyValue(enabled, node, evt);
        }
        if (enabled && !this.mSet.getBooleanValue()) {
            this.mSet.setValue(true);
        }
        this.internalChange = false;
        this.setStyle(selection.getSelected());
    }

    void setStyle(NodeModel node) {
        if (this.internalChange) {
            return;
        }
        this.internalChange = true;
        try {
            this.setStyleOnExternalChange(node);
        }
        finally {
            this.internalChange = false;
        }
        this.adjustForStyle(node);
    }

    abstract void setStyleOnExternalChange(NodeModel var1);

    abstract void adjustForStyle(NodeModel var1);
}

