/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.components.InfoArea;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.LoadAcceleratorPresetsAction;

public class SaveAcceleratorPresetsAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SaveAcceleratorPresetsAction() {
        super("SaveAcceleratorPresetsAction");
    }

    public void actionPerformed(ActionEvent e) {
        int confirm;
        File acceleratorsUserDirectory = LoadAcceleratorPresetsAction.getAcceleratorsUserDirectory();
        String keyset = this.inputPresetName(acceleratorsUserDirectory);
        if (keyset == null || keyset.equals("")) {
            return;
        }
        File keysetFile = new File(acceleratorsUserDirectory, keyset + ".properties");
        if (keysetFile.exists() && (confirm = JOptionPane.showConfirmDialog(UITools.getMenuComponent(), TextUtils.getText((String)"overwrite_keyset_question"), "Freeplane", 0)) != 0) {
            return;
        }
        try {
            acceleratorsUserDirectory.mkdirs();
            IUserInputListenerFactory userInputListenerFactory = Controller.getCurrentModeController().getUserInputListenerFactory();
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(keysetFile));){
                ResourceController.getResourceController().getAcceleratorManager().storeAcceleratorPreset((OutputStream)output);
            }
            userInputListenerFactory.rebuildMenus("load_accelerator_presets");
        }
        catch (IOException e1) {
            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_save_key_set"));
        }
    }

    private String inputPresetName(File acceleratorsUserDirectory) {
        InfoArea info = new InfoArea();
        info.setColumns(40);
        info.setLineWrap(true);
        info.setWrapStyleWord(false);
        info.setFont(info.getFont().deriveFont(2));
        info.setAlignmentX(0.5f);
        info.setText(TextUtils.format((String)"loadHotKeysHelp", (Object[])new Object[]{acceleratorsUserDirectory.getAbsolutePath()}));
        JTextField inputField = new JTextField(40);
        inputField.setAlignmentX(0.5f);
        Box dialogComponents = Box.createVerticalBox();
        dialogComponents.add(inputField);
        dialogComponents.add((Component)info);
        FocusRequestor.requestFocus((Component)inputField);
        int result = JOptionPane.showConfirmDialog(UITools.getMenuComponent(), dialogComponents, TextUtils.getText((String)"enter_keyset_name"), 2, -1);
        String presetName = result == 0 ? inputField.getText() : "";
        return presetName;
    }
}

