/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JTextField;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.URIUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class SetLinkByTextFieldAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SetLinkByTextFieldAction() {
        super("SetLinkByTextFieldAction");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel selectedNode = modeController.getMapController().getSelectedNode();
        String linkAsString = NodeLinks.getLinkAsString((NodeModel)selectedNode);
        if (Compat.isWindowsOS() && linkAsString != null && linkAsString.startsWith("smb:")) {
            Hyperlink link = NodeLinks.getValidLink((NodeModel)selectedNode);
            linkAsString = Compat.smbUri2unc((URI)link.getUri());
        }
        if (linkAsString == null || "".equals(linkAsString)) {
            linkAsString = "http://";
            Transferable t = ClipboardAccessor.getInstance().getClipboardContents();
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString().trim();
                    URIUtils.createURIFromString((String)plainTextFromClipboard);
                    linkAsString = plainTextFromClipboard;
                }
                catch (Exception plainTextFromClipboard) {
                    // empty catch block
                }
            }
        }
        JTextField inputField = new JTextField(60);
        inputField.setText(linkAsString);
        inputField.setSelectionStart(0);
        inputField.setSelectionEnd(linkAsString.length());
        FocusRequestor.requestFocus((Component)inputField);
        int result = UITools.showConfirmDialog((NodeModel)Controller.getCurrentController().getSelection().getSelected(), (Object)inputField, (String)TextUtils.getText((String)"edit_link_manually"), (int)2);
        String inputValue = inputField.getText();
        if (inputValue.length() >= 2 && inputValue.startsWith("\"") && inputValue.endsWith("\"")) {
            inputValue = inputValue.substring(1, inputValue.length() - 1);
        }
        if (result == 0 && !inputValue.matches("\\w+://")) {
            MLinkController linkController = (MLinkController)MLinkController.getController();
            if (inputValue.equals("")) {
                linkController.setLink(selectedNode, (URI)null, 0);
                return;
            }
            try {
                Hyperlink link = LinkController.createHyperlink((String)inputValue.trim());
                linkController.setLink(selectedNode, link);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn((Throwable)e1);
                UITools.errorMessage((Object)TextUtils.format((String)"invalid_uri", (Object[])new Object[]{inputValue}));
                return;
            }
        }
    }
}

