/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkIndexCalculator;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkTransferables;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropExecutor;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropValidation;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropValidator;
import org.freeplane.features.bookmarks.mindmapmode.ui.HoverTimer;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.ui.NodeDropUtils;

class BookmarkDropTargetListener
extends DropTargetAdapter {
    private final DropValidator validator;
    private final DropExecutor executor;
    private final HoverTimer hoverTimer;

    public BookmarkDropTargetListener(BookmarkToolbar toolbar, BookmarksController bookmarksController) {
        this.validator = new DropValidator(toolbar);
        this.executor = new DropExecutor(toolbar, bookmarksController);
        this.hoverTimer = new HoverTimer();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Component targetComponent = dtde.getDropTargetContext().getComponent();
        if (targetComponent instanceof BookmarkButton) {
            BookmarkButton targetButton = (BookmarkButton)targetComponent;
            if (dtde.isDataFlavorSupported(BookmarkTransferables.BOOKMARK_FLAVOR)) {
                this.handleBookmarkDragOver(dtde, targetButton);
            } else if (NodeDropUtils.isDragAcceptable((DropTargetDragEvent)dtde, (NodeModel)targetButton.getBookmark().getNode(), (NodeDropUtils.AcceptedContent)NodeDropUtils.AcceptedContent.ANY)) {
                this.handleNodeDragOver(dtde, targetButton);
            } else {
                dtde.rejectDrag();
                targetButton.clearVisualFeedback();
                this.hoverTimer.cancelHoverTimer();
            }
        } else if (targetComponent instanceof BookmarkToolbar) {
            BookmarkToolbar toolbar = (BookmarkToolbar)((Object)targetComponent);
            if (dtde.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
                this.handleNodeDragOverToolbar(dtde, toolbar);
            } else {
                dtde.rejectDrag();
                toolbar.clearVisualFeedback();
                this.hoverTimer.cancelHoverTimer();
            }
        } else {
            dtde.rejectDrag();
        }
    }

    private void handleBookmarkDragOver(DropTargetDragEvent dtde, BookmarkButton targetButton) {
        try {
            int sourceIndex = (Integer)dtde.getTransferable().getTransferData(BookmarkTransferables.BOOKMARK_FLAVOR);
            Point dropPoint = dtde.getLocation();
            DropValidation validation = this.validator.validateDrop(sourceIndex, targetButton, dropPoint);
            if (!validation.isValid) {
                dtde.rejectDrag();
                targetButton.clearVisualFeedback();
                this.hoverTimer.cancelHoverTimer();
                return;
            }
            dtde.acceptDrag(2);
            targetButton.showDropZoneIndicator(validation.dropsAfter);
            this.hoverTimer.cancelHoverTimer();
        }
        catch (Exception e) {
            dtde.rejectDrag();
            targetButton.clearVisualFeedback();
            this.hoverTimer.cancelHoverTimer();
        }
    }

    private void handleNodeDragOver(DropTargetDragEvent dtde, BookmarkButton targetButton) {
        try {
            Point dropPoint = dtde.getLocation();
            NodeDropZone dropZone = this.determineNodeDropZone(targetButton, dropPoint);
            int dragActionType = NodeDropUtils.getDropAction((Transferable)dtde.getTransferable(), (int)dtde.getDropAction());
            if (dropZone.isLateral()) {
                NodeModel draggedNode;
                if (dtde.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor) && (draggedNode = this.extractSingleNode(dtde)) == null) {
                    dtde.rejectDrag();
                    return;
                }
                dtde.acceptDrag(dragActionType);
                targetButton.showDropZoneIndicator(dropZone.isAfter());
                this.hoverTimer.cancelHoverTimer();
            } else {
                dtde.acceptDrag(dragActionType);
                targetButton.showFeedback(BookmarkToolbar.DropIndicatorType.HOVER_FEEDBACK);
                this.hoverTimer.startHoverTimer(targetButton);
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
            targetButton.clearVisualFeedback();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        Component targetComponent = dte.getDropTargetContext().getComponent();
        if (targetComponent instanceof BookmarkButton) {
            BookmarkButton button = (BookmarkButton)targetComponent;
            button.clearVisualFeedback();
        } else if (targetComponent instanceof BookmarkToolbar) {
            BookmarkToolbar toolbar = (BookmarkToolbar)((Object)targetComponent);
            toolbar.clearVisualFeedback();
        }
        this.hoverTimer.cancelHoverTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        Component targetComponent = dtde.getDropTargetContext().getComponent();
        this.hoverTimer.cancelHoverTimer();
        try {
            if (targetComponent instanceof BookmarkButton) {
                BookmarkButton targetButton = (BookmarkButton)targetComponent;
                if (dtde.isDataFlavorSupported(BookmarkTransferables.BOOKMARK_FLAVOR)) {
                    this.handleBookmarkDrop(dtde, targetButton);
                } else if (NodeDropUtils.isDropAcceptable((DropTargetDropEvent)dtde, (NodeModel)targetButton.getBookmark().getNode(), (int)NodeDropUtils.getDropAction((DropTargetDropEvent)dtde), (NodeDropUtils.AcceptedContent)NodeDropUtils.AcceptedContent.ANY)) {
                    this.handleNodeDrop(dtde, targetButton);
                } else {
                    dtde.rejectDrop();
                }
            } else if (targetComponent instanceof BookmarkToolbar) {
                BookmarkToolbar toolbar = (BookmarkToolbar)((Object)targetComponent);
                if (dtde.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
                    this.handleNodeDropOnToolbar(dtde, toolbar);
                } else {
                    dtde.rejectDrop();
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
        }
        finally {
            if (targetComponent instanceof BookmarkButton) {
                ((BookmarkButton)targetComponent).clearVisualFeedback();
            } else if (targetComponent instanceof BookmarkToolbar) {
                ((BookmarkToolbar)((Object)targetComponent)).clearVisualFeedback();
            }
        }
    }

    private void handleBookmarkDrop(DropTargetDropEvent dtde, BookmarkButton targetButton) throws UnsupportedFlavorException, IOException {
        int sourceIndex = (Integer)dtde.getTransferable().getTransferData(BookmarkTransferables.BOOKMARK_FLAVOR);
        Point dropPoint = dtde.getLocation();
        DropValidation validation = this.validator.validateDrop(sourceIndex, targetButton, dropPoint);
        if (!validation.isValid) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(2);
        this.executor.moveBookmark(sourceIndex, validation.finalTargetIndex);
        dtde.dropComplete(true);
    }

    private void handleNodeDrop(DropTargetDropEvent dtde, BookmarkButton targetButton) {
        try {
            Point dropPoint = dtde.getLocation();
            NodeDropZone dropZone = this.determineNodeDropZone(targetButton, dropPoint);
            int dropAction = NodeDropUtils.getDropAction((DropTargetDropEvent)dtde);
            if (dropZone.isLateral()) {
                if (dtde.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
                    NodeModel draggedNode = this.extractSingleNode(dtde);
                    if (draggedNode == null) {
                        dtde.rejectDrop();
                        return;
                    }
                    dtde.acceptDrop(dropAction);
                    boolean success = this.executor.createBookmarkFromNodeAtPosition(dtde, dropZone.getInsertionIndex());
                    dtde.dropComplete(success);
                } else {
                    dtde.rejectDrop();
                }
            } else {
                NodeModel targetNode = targetButton.getBookmark().getNode();
                Transferable t = dtde.getTransferable();
                if (!dtde.isLocalTransfer()) {
                    dtde.acceptDrop(1);
                    NodeDropUtils.handleMoveOrCopyAction((Transferable)t, (NodeModel)targetNode, (int)dropAction, (boolean)dtde.isLocalTransfer(), (InsertionRelation)InsertionRelation.AS_CHILD, (NodeModel.Side)NodeModel.Side.DEFAULT);
                    dtde.dropComplete(true);
                    return;
                }
                dtde.acceptDrop(dropAction);
                if (dropAction == 0x40000000) {
                    Controller controller = Controller.getCurrentController();
                    ModeController modeController = controller.getModeController();
                    NodeDropUtils.handleLinkAction((Transferable)t, (NodeModel)targetNode, (Controller)controller, (ModeController)modeController);
                } else {
                    NodeDropUtils.handleMoveOrCopyAction((Transferable)t, (NodeModel)targetNode, (int)dropAction, (boolean)dtde.isLocalTransfer(), (InsertionRelation)InsertionRelation.AS_CHILD, (NodeModel.Side)NodeModel.Side.DEFAULT);
                }
                dtde.dropComplete(true);
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    private void handleNodeDragOverToolbar(DropTargetDragEvent dtde, BookmarkToolbar toolbar) {
        try {
            NodeModel draggedNode = this.extractSingleNode(dtde);
            if (draggedNode == null) {
                dtde.rejectDrag();
                return;
            }
            Point dropPoint = dtde.getLocation();
            if (!this.isPointInContentArea(toolbar, dropPoint)) {
                dtde.rejectDrag();
                return;
            }
            BookmarkIndexCalculator.ToolbarDropPosition position = this.validator.calculateToolbarDropPosition(dropPoint);
            this.showToolbarDropFeedback(toolbar, position);
            this.hoverTimer.cancelHoverTimer();
            int dragActionType = NodeDropUtils.getDropAction((Transferable)dtde.getTransferable(), (int)dtde.getDropAction());
            dtde.acceptDrag(dragActionType);
        }
        catch (Exception e) {
            dtde.rejectDrag();
            toolbar.clearVisualFeedback();
        }
    }

    private void handleNodeDropOnToolbar(DropTargetDropEvent dtde, BookmarkToolbar toolbar) {
        try {
            NodeModel draggedNode = this.extractSingleNode(dtde);
            if (draggedNode == null) {
                dtde.rejectDrop();
                return;
            }
            Point dropPoint = dtde.getLocation();
            if (!this.isPointInContentArea(toolbar, dropPoint)) {
                dtde.rejectDrop();
                return;
            }
            BookmarkIndexCalculator.ToolbarDropPosition position = this.validator.calculateToolbarDropPosition(dropPoint);
            int dragActionType = NodeDropUtils.getDropAction((Transferable)dtde.getTransferable(), (int)dtde.getDropAction());
            dtde.acceptDrop(dragActionType);
            boolean success = this.executor.createBookmarkFromNodeAtPosition(dtde, position.getInsertionIndex());
            dtde.dropComplete(success);
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    private boolean isPointInContentArea(BookmarkToolbar toolbar, Point point) {
        Insets insets = toolbar.getInsets();
        int x = point.x;
        int y = point.y;
        int width = toolbar.getWidth();
        int height = toolbar.getHeight();
        return x >= insets.left && x < width - insets.right && y >= insets.top && y < height - insets.bottom;
    }

    private NodeModel extractSingleNode(DropTargetDragEvent dtde) throws Exception {
        BookmarkToolbar toolbar = this.getToolbarFromEvent(dtde);
        return this.extractSingleNode(dtde.getTransferable(), toolbar);
    }

    private NodeModel extractSingleNode(DropTargetDropEvent dtde) throws Exception {
        BookmarkToolbar toolbar = this.getToolbarFromEvent(dtde);
        return this.extractSingleNode(dtde.getTransferable(), toolbar);
    }

    private BookmarkToolbar getToolbarFromEvent(DropTargetEvent dte) {
        Component component = dte.getDropTargetContext().getComponent();
        if (component instanceof BookmarkToolbar) {
            return (BookmarkToolbar)((Object)component);
        }
        if (component instanceof BookmarkButton) {
            return (BookmarkToolbar)((Object)component.getParent());
        }
        Container parent = component.getParent();
        if (parent instanceof BookmarkToolbar) {
            return (BookmarkToolbar)((Object)parent);
        }
        throw new IllegalArgumentException("Event target is not associated with a BookmarkToolbar");
    }

    private NodeModel extractSingleNode(Transferable transferable, BookmarkToolbar toolbar) throws Exception {
        Collection draggedNodesCollection = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
        ArrayList draggedNodes = new ArrayList(draggedNodesCollection);
        if (draggedNodes.size() != 1) {
            return null;
        }
        NodeModel draggedNode = (NodeModel)draggedNodes.get(0);
        MapModel nodeMap = draggedNode.getMap();
        MapModel toolbarMap = toolbar.getMap();
        return nodeMap != null && nodeMap.equals(toolbarMap) ? draggedNode : null;
    }

    private void showToolbarDropFeedback(BookmarkToolbar toolbar, BookmarkIndexCalculator.ToolbarDropPosition position) {
        switch (position.type) {
            case BEFORE_BUTTON: {
                Component component;
                if (position.buttonIndex >= toolbar.getComponentCount() || !((component = toolbar.getComponent(position.buttonIndex)) instanceof BookmarkButton)) break;
                BookmarkButton button = (BookmarkButton)component;
                button.showFeedback(BookmarkToolbar.DropIndicatorType.DROP_BEFORE);
                break;
            }
            case AFTER_BUTTON: {
                Component component;
                if (position.buttonIndex >= toolbar.getComponentCount() || !((component = toolbar.getComponent(position.buttonIndex)) instanceof BookmarkButton)) break;
                BookmarkButton button = (BookmarkButton)component;
                button.showFeedback(BookmarkToolbar.DropIndicatorType.DROP_AFTER);
                break;
            }
            case AT_END: {
                toolbar.showEndDropIndicator();
            }
        }
    }

    private NodeDropZone determineNodeDropZone(BookmarkButton button, Point dropPoint) {
        int buttonWidth = button.getWidth();
        int edgeThreshold = Math.max(BookmarkToolbar.GAP, buttonWidth / 6);
        if (dropPoint.x <= edgeThreshold) {
            BookmarkToolbar toolbar = (BookmarkToolbar)((Object)button.getParent());
            int buttonIndex = toolbar.getComponentIndex(button);
            return new NodeDropZone(true, false, buttonIndex);
        }
        if (dropPoint.x >= buttonWidth - edgeThreshold) {
            BookmarkToolbar toolbar = (BookmarkToolbar)((Object)button.getParent());
            int buttonIndex = toolbar.getComponentIndex(button);
            return new NodeDropZone(true, true, buttonIndex + 1);
        }
        return new NodeDropZone(false, false, -1);
    }

    private static class NodeDropZone {
        private final boolean lateral;
        private final boolean after;
        private final int insertionIndex;

        public NodeDropZone(boolean lateral, boolean after, int insertionIndex) {
            this.lateral = lateral;
            this.after = after;
            this.insertionIndex = insertionIndex;
        }

        public boolean isLateral() {
            return this.lateral;
        }

        public boolean isAfter() {
            return this.after;
        }

        public int getInsertionIndex() {
            return this.insertionIndex;
        }
    }
}

