/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkClipboardHandler;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkDragGestureListener;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkDropTargetListener;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkIconFactory;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkPopupMenu;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.NodeTooltipManager;

class BookmarkButtonConfigurator {
    private static final String COPY_ACTION_KEY = "bookmarkCopy";
    private static final String PASTE_ACTION_KEY = "bookmarkPaste";
    private static final String ENTER_ACTION_KEY = "bookmarkEnter";
    private static final ButtonEnterAction CLICK_ACTION = new ButtonEnterAction();
    private static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, menuShortcutKeyMask);
    private static final KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, menuShortcutKeyMask);
    private static final KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke altEnterKeyStroke = KeyStroke.getKeyStroke(10, 8);
    private final BookmarksController bookmarksController;
    private final ModeController modeController;

    BookmarkButtonConfigurator(BookmarksController bookmarksController, ModeController modeController) {
        this.bookmarksController = bookmarksController;
        this.modeController = modeController;
    }

    void configureButton(BookmarkButton button, NodeBookmark bookmark, BookmarkToolbar toolbar, IMapSelection selection) {
        NodeBookmarkDescriptor descriptor = bookmark.getDescriptor();
        NodeModel node = bookmark.getNode();
        button.setText(descriptor.getName());
        button.addActionListener(this::applyAction);
        button.putClientProperty("tooltipLocation", "above");
        this.registerTooltip(button);
        this.setButtonIcon(button, node, descriptor);
        this.setupDragAndDrop(button, toolbar);
        this.setupActionMap(button, toolbar);
        this.addMouseListener(button);
    }

    void configureNonBookmarkComponent(Component component) {
        DropTarget dropTarget = new DropTarget(component, 0, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.rejectDrop();
            }
        });
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            button.getInputMap().put(enterKeyStroke, ENTER_ACTION_KEY);
            button.getActionMap().put(ENTER_ACTION_KEY, CLICK_ACTION);
        }
    }

    private void applyAction(ActionEvent action) {
        BookmarkButton button = (BookmarkButton)action.getSource();
        if ((action.getModifiers() & 2) != 0) {
            this.showBookmarkPopupMenu(button);
        } else {
            NodeBookmark bookmark = button.getBookmark();
            if ((action.getModifiers() & 8) != 0) {
                bookmark.alternativeOpen();
            } else {
                bookmark.open();
            }
        }
    }

    private void registerTooltip(BookmarkButton button) {
        NodeTooltipManager toolTipManager = NodeTooltipManager.getSharedInstance((ModeController)this.modeController);
        toolTipManager.registerComponent((JComponent)button);
    }

    private void setButtonIcon(BookmarkButton button, NodeModel node, NodeBookmarkDescriptor descriptor) {
        button.setIcon(BookmarkIconFactory.createIcon(node, descriptor));
    }

    private void setupDragAndDrop(BookmarkButton button, BookmarkToolbar toolbar) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(button, 0x40000003, new BookmarkDragGestureListener(button));
        DropTarget dropTarget = new DropTarget(button, 3, new BookmarkDropTargetListener(toolbar, this.bookmarksController));
    }

    private void setupActionMap(BookmarkButton button, BookmarkToolbar toolbar) {
        InputMap inputMap = button.getInputMap(0);
        ActionMap actionMap = button.getActionMap();
        inputMap.put(copyKeyStroke, COPY_ACTION_KEY);
        inputMap.put(pasteKeyStroke, PASTE_ACTION_KEY);
        inputMap.put(enterKeyStroke, ENTER_ACTION_KEY);
        inputMap.put(altEnterKeyStroke, ENTER_ACTION_KEY);
        actionMap.put(COPY_ACTION_KEY, new ButtonCopyAction());
        actionMap.put(PASTE_ACTION_KEY, new ButtonPasteAction());
        actionMap.put(ENTER_ACTION_KEY, CLICK_ACTION);
        AbstractAction showContextMenuAction = new AbstractAction("showContextMenu"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkButton button = (BookmarkButton)e.getSource();
                BookmarkButtonConfigurator.this.showBookmarkPopupMenu(button);
            }
        };
        button.getInputMap().put(KeyStroke.getKeyStroke(525, 0), "showContextMenu");
        button.getInputMap().put(KeyStroke.getKeyStroke(121, 128), "showContextMenu");
        button.getActionMap().put("showContextMenu", showContextMenuAction);
    }

    private void addMouseListener(final BookmarkButton button) {
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    BookmarkButtonConfigurator.this.showBookmarkPopupMenu(button);
                }
            }
        });
    }

    private void showBookmarkPopupMenu(BookmarkButton button) {
        BookmarkPopupMenu popup = new BookmarkPopupMenu(button.getBookmark(), this.bookmarksController);
        int menuHeight = popup.getPreferredSize().height;
        popup.show(button, 0, -menuHeight);
    }

    private static class ButtonEnterAction
    extends AbstractAction {
        private ButtonEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            button.doClick();
            button.requestFocus();
        }
    }

    private static class ButtonCopyAction
    extends AbstractAction {
        private ButtonCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkButton button = (BookmarkButton)e.getSource();
            Container parent = button.getParent();
            if (parent instanceof BookmarkToolbar) {
                BookmarkToolbar toolbar = (BookmarkToolbar)((Object)parent);
                BookmarkClipboardHandler clipboardHandler = toolbar.getClipboardHandler();
                clipboardHandler.copyBookmark(button);
            }
        }
    }

    private static class ButtonPasteAction
    extends AbstractAction {
        private ButtonPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkButton button = (BookmarkButton)e.getSource();
            Container parent = button.getParent();
            if (parent instanceof BookmarkToolbar) {
                BookmarkToolbar toolbar = (BookmarkToolbar)((Object)parent);
                BookmarkClipboardHandler clipboardHandler = toolbar.getClipboardHandler();
                clipboardHandler.pasteBookmarkAtButton(button);
            }
        }
    }
}

