/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;

class RestartAtLM {
    protected boolean invalidPosition;
    private Position lineBreakPosition;
    private int positionIndex;

    RestartAtLM() {
    }

    protected LayoutManager getRestartAtLM(AbstractBreaker breaker, PageBreakingAlgorithm alg, boolean ipdChangesOnNextPage, boolean onLastPageAndIPDChanges, boolean visitedBefore, AbstractBreaker.BlockSequence blockList, int start) {
        BreakingAlgorithm.KnuthNode optimalBreak;
        this.lineBreakPosition = null;
        BreakingAlgorithm.KnuthNode knuthNode = optimalBreak = ipdChangesOnNextPage ? alg.getBestNodeBeforeIPDChange() : alg.getBestNodeForLastPage();
        if (onLastPageAndIPDChanges && visitedBefore && breaker.originalRestartAtLM == null) {
            optimalBreak = null;
        }
        this.findPositionIndex(breaker, optimalBreak, alg, start);
        if (!breaker.getPageProvider().foUserAgent.isLegacyLastPageChangeIPD() && breaker.positionAtBreak.getLM() instanceof BlockLayoutManager) {
            this.findPositionIndexForBlockLayout(breaker, optimalBreak, alg);
        }
        if (ipdChangesOnNextPage || breaker.positionAtBreak != null && breaker.positionAtBreak.getIndex() > -1) {
            breaker.firstElementsForRestart = Collections.EMPTY_LIST;
            if (ipdChangesOnNextPage && breaker.containsNonRestartableLM(breaker.positionAtBreak)) {
                if (alg.getIPDdifference() > 0) {
                    EventBroadcaster eventBroadcaster = breaker.getCurrentChildLM().getFObj().getUserAgent().getEventBroadcaster();
                    BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(eventBroadcaster);
                    eventProducer.nonRestartableContentFlowingToNarrowerPage(this);
                }
                breaker.firstElementsForRestart = new LinkedList<ListElement>();
                boolean boxFound = false;
                ListIterator iter = blockList.listIterator(this.positionIndex + 1);
                Position position = null;
                while (iter.hasNext() && (position == null || breaker.containsNonRestartableLM(position))) {
                    ++this.positionIndex;
                    KnuthElement element = (KnuthElement)iter.next();
                    position = element.getPosition();
                    if (element.isBox()) {
                        boxFound = true;
                        breaker.firstElementsForRestart.add(element);
                        continue;
                    }
                    if (!boxFound) continue;
                    breaker.firstElementsForRestart.add(element);
                }
                breaker.positionAtBreak = position instanceof SpaceResolver.SpaceHandlingBreakPosition ? position.getPosition() : null;
            }
        }
        LayoutManager restartAtLM = null;
        if (ipdChangesOnNextPage || breaker.positionAtBreak == null || breaker.positionAtBreak.getIndex() <= -1) {
            if (breaker.positionAtBreak != null && breaker.positionAtBreak.getIndex() == -1) {
                KnuthElement nextElement;
                Position position;
                ListIterator iter = blockList.listIterator(this.positionIndex + 1);
                while ((position = (nextElement = (KnuthElement)iter.next()).getPosition()) == null || position instanceof SpaceResolver.SpaceHandlingPosition || position instanceof SpaceResolver.SpaceHandlingBreakPosition && position.getPosition().getIndex() == -1) {
                }
                LayoutManager surroundingLM = breaker.positionAtBreak.getLM();
                while (position.getLM() != surroundingLM) {
                    position = position.getPosition();
                }
                if (position.getPosition() == null) {
                    if (!position.getLM().getFObj().isForceKeepTogether()) {
                        position.getLM().getFObj().setForceKeepTogether(true);
                        this.invalidPosition = true;
                    }
                    return null;
                }
                restartAtLM = position.getPosition().getLM();
            }
            if (onLastPageAndIPDChanges && restartAtLM != null) {
                if (breaker.originalRestartAtLM == null) {
                    breaker.originalRestartAtLM = restartAtLM;
                } else {
                    restartAtLM = breaker.originalRestartAtLM;
                }
                breaker.firstElementsForRestart = Collections.EMPTY_LIST;
            }
        }
        if (onLastPageAndIPDChanges && !visitedBefore && breaker.positionAtBreak.getPosition() != null) {
            restartAtLM = breaker.positionAtBreak.getPosition().getLM();
        }
        if (this.lineBreakPosition != null && restartAtLM instanceof BlockLayoutManager) {
            breaker.positionAtBreak = this.lineBreakPosition;
        }
        return restartAtLM;
    }

    private void findPositionIndex(AbstractBreaker breaker, BreakingAlgorithm.KnuthNode optimalBreak, PageBreakingAlgorithm alg, int start) {
        for (int i = this.positionIndex = optimalBreak != null ? optimalBreak.position : start; i < alg.par.size(); ++i) {
            KnuthElement elementAtBreak = alg.getElement(i);
            if (elementAtBreak.getPosition() == null) {
                elementAtBreak = alg.getElement(0);
            }
            breaker.positionAtBreak = elementAtBreak.getPosition();
            breaker.positionAtBreak = breaker.positionAtBreak.getPosition();
            if (breaker.positionAtBreak == null) continue;
            this.positionIndex = i;
            return;
        }
    }

    private void findPositionIndexForBlockLayout(AbstractBreaker breaker, BreakingAlgorithm.KnuthNode optimalBreak, PageBreakingAlgorithm alg) {
        int positionIndex;
        for (int i = positionIndex = optimalBreak != null ? optimalBreak.position : 0; i < alg.par.size(); ++i) {
            KnuthElement elementAtBreak = alg.getElement(i);
            if (elementAtBreak.getPosition() == null) {
                elementAtBreak = alg.getElement(0);
            }
            Position positionAtBreak = elementAtBreak.getPosition();
            if ((positionAtBreak = positionAtBreak.getPosition()) == null) continue;
            this.findLineBreakPosition(positionAtBreak);
            if (this.lineBreakPosition == null) break;
            breaker.positionAtBreak = positionAtBreak;
            this.positionIndex = i;
            break;
        }
    }

    private void findLineBreakPosition(Position positionAtBreak) {
        while (positionAtBreak instanceof NonLeafPosition) {
            if (!((positionAtBreak = positionAtBreak.getPosition()) instanceof LineLayoutManager.LineBreakPosition)) continue;
            this.lineBreakPosition = positionAtBreak;
        }
    }
}

