#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-HkMiae182ET25dJ7X9Wbvq
key:                  dhall-1.42.2-HkMiae182ET25dJ7X9Wbvq
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  ca3e2d54d76e1cdb561e8c03615323be
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-HkMiae182ET25dJ7X9Wbvq
depends:
    Diff-0.4.1-54jN24YTNqv3C30Bh41O9s
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    aeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa
    ansi-terminal-1.0.2-HptUcAgyCR58cokR0SMdxn
    atomic-write-0.2.1.1-B47svdOEweh4IWZSyLf9DP base-4.17.2.1
    base16-bytestring-1.0.2.0-LUU3ms9NsF4GQtyGeO8pva
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-LsX0nU5KPAoJUeisZm5xEf
    cborg-0.2.10.0-BOTWqPZJingGpMlpcpvt2A
    cborg-json-0.2.6.0-D4VdlMZLo2BNE3sunLPSb containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-GlI6J0iALmR3Ajx7WCWQyw
    data-fix-0.3.4-2U6u4MFYu1eCUd14z6QYlH deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-AM3UF2TrU5o772ZgVRvSWL exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-BVeNUTZXMdH73LoFeNbDCq
    hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2 haskeline-0.8.2
    http-client-0.7.19-IOiFZdMrMxf1FD0Q8GvNdl
    http-client-tls-0.3.6.4-5Ho7Yjl7j7WL01BIog0cDK
    http-types-0.12.4-BvZSYA7IliCW0EQtF31VI
    indexed-traversable-0.1.4-C3JpN7YDWmy6ZJ7hWVfhAu
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-2LveF0uKMovFZzLupvHuy3
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-37qi4fIAhTC8owHWseusWs
    optparse-applicative-0.18.1.0-7qc0weJVpOv49HyNgUQM9q
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-DfQ8JE6XFwnCtItVAIGDwE
    pretty-simple-4.1.3.0-8ivhYjoxML4A2StWNBEQuq
    prettyprinter-1.7.1-5cxpZ3jZU7h3nFjq43pkKP
    prettyprinter-ansi-terminal-1.1.3-DOKqyPGKM8ODcj1VptIqod
    profunctors-5.6.3-CZGRj4axmFA9bHsS9eciFX
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-JrlaAXGfnydA9ZtLsuTElg
    serialise-0.2.6.1-3Nxn0OPRv5A6nv0SOiLWj7 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-7Rgcl0hH4Fp2t0qUzHihZ0
    text-short-0.1.6-EW5FkDEoN866ClqGHk9taZ
    th-lift-instances-0.1.20-50lKQ3Y2qaH31N12RxK2sY time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-9HzsqtSzPkh2Dunn9NmEMr
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

