/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class UpdateTableModel
extends UnitCategoryTableModel {
    private OperationContainer<InstallSupport> container = Containers.forUpdate();
    private OperationContainer<OperationSupport> containerCustom = Containers.forCustomInstall();
    private static String col0;
    private static String col1;
    private static String col2;

    public UpdateTableModel(List<UpdateUnit> list) {
        this.setUnits(list);
    }

    @Override
    public final void setUnits(List<UpdateUnit> list) {
        this.setData(Utilities.makeUpdateCategories(list, false));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isExpansionControlAtRow(n)) {
            return;
        }
        if (n2 == 1) {
            return;
        }
        super.setValueAt(object, n, n2);
        Unit unit = this.getUnitAtRow(n);
        assert (object instanceof Boolean) : object + " must be instanceof Boolean.";
        boolean bl = unit.isMarked();
        if ((Boolean)object != bl) {
            unit.setMarked(!bl);
            if (unit.isMarked() != bl) {
                this.fireButtonsChange();
            } else {
                String string = NbBundle.getMessage(UpdateTableModel.class, (String)"NotificationAlreadyPreparedToIntsall", (Object)unit.getDisplayName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (this.isExpansionControlAtRow(n)) {
            return "";
        }
        Unit unit = this.getUnitAtRow(n);
        switch (n2) {
            case 0: {
                object = unit.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                object = unit.getDisplayName();
                break;
            }
            case 2: {
                object = unit.getCategoryName();
            }
        }
        return object;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = DisplayName.class;
                break;
            }
            case 2: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                if (col0 == null) {
                    col0 = this.getBundle("UpdateTableModel_Columns_Update");
                }
                return col0;
            }
            case 1: {
                if (col1 == null) {
                    col1 = this.getBundle("UpdateTableModel_Columns_Name");
                }
                return col1;
            }
            case 2: {
                if (col2 == null) {
                    col2 = this.getBundle("UpdateTableModel_Columns_Category");
                }
                return col2;
            }
        }
        assert (false);
        return super.getColumnName(n);
    }

    @Override
    public int getPreferredWidth(JTableHeader jTableHeader, int n) {
        int n2 = super.getMinWidth(jTableHeader, n);
        switch (n) {
            case 1: {
                return n2 * 4;
            }
            case 2: {
                return n2 * 2;
            }
        }
        return n2;
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.UPDATE;
    }

    @Override
    public boolean isSortAllowed(Object object) {
        boolean bl = this.getColumnName(0).equals(object);
        return !bl;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object object, final boolean bl) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit unit, Unit unit2) {
                Unit unit3;
                Unit unit4 = bl ? unit : unit2;
                Unit unit5 = unit3 = bl ? unit2 : unit;
                if (UpdateTableModel.this.getColumnName(0).equals(object)) {
                    assert (false) : object.toString();
                } else {
                    if (UpdateTableModel.this.getColumnName(1).equals(object)) {
                        return Unit.compareDisplayNames(unit4, unit3);
                    }
                    if (UpdateTableModel.this.getColumnName(2).equals(object)) {
                        return Unit.compareCategories(unit4, unit3);
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        int n = 0;
        assert (this.container != null || this.containerCustom != null) : "OperationContainer found when asking for download size.";
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.container.listAll());
        hashSet.addAll(this.containerCustom.listAll());
        HashSet<UpdateElement> hashSet2 = new HashSet<UpdateElement>();
        for (OperationContainer.OperationInfo operationInfo : hashSet) {
            if (!hashSet2.add(operationInfo.getUpdateElement())) continue;
            hashSet2.addAll(operationInfo.getRequiredElements());
        }
        for (UpdateElement updateElement : hashSet2) {
            n += updateElement.getDownloadSize();
        }
        return n;
    }

    private String getBundle(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_Title");
    }

    @Override
    public String getTabTooltipText() {
        if (this.isTabEnabled()) {
            return super.getTabTooltipText();
        }
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_ToolTip");
    }

    @Override
    public int getTabIndex() {
        return 0;
    }

    @Override
    public boolean isTabEnabled() {
        return true;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    public class DisplayName {
        public DisplayName(String string) {
        }
    }
}

