/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.util.BaseUtilities;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class NbBundleProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(NbBundle.Messages.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Object object;
        Object object2;
        Object object3;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        HashMap hashMap = new HashMap();
        for (Element object4 : roundEnvironment.getElementsAnnotatedWith(NbBundle.Messages.class)) {
            object3 = object4.getAnnotation(NbBundle.Messages.class);
            if (object3 == null) continue;
            object2 = this.findPackage(object4);
            object = (Set)hashMap.get(object2);
            if (object == null) {
                object = new HashSet();
                hashMap.put(object2, object);
            }
            object.add(object4);
        }
        block23: for (Map.Entry entry : hashMap.entrySet()) {
            String[] stringArray;
            Object object4;
            Object iOException;
            Object object5;
            Cloneable cloneable;
            object3 = (String)entry.getKey();
            object2 = (Set)entry.getValue();
            object = this.processingEnv.getElementUtils().getPackageElement((CharSequence)object3);
            if (object != null) {
                cloneable = new HashSet<Object>();
                cloneable.add(object);
                try {
                    cloneable.addAll(object.getEnclosedElements());
                }
                catch (RuntimeException runtimeException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "#196556: reading " + (String)object3 + " failed with " + runtimeException + " in " + runtimeException.getStackTrace()[0] + "; do a clean build!");
                }
                cloneable.removeAll(roundEnvironment.getRootElements());
                this.addToAnnotatedElements((Collection<? extends Element>)((Object)cloneable), (Set<Element>)object2);
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not check for other source files in " + (String)object3);
            }
            cloneable = new HashMap();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            HashMap<String, String[]> hashMap4 = new HashMap<String, String[]>();
            Element[] elementArray = object2.iterator();
            while (elementArray.hasNext()) {
                object5 = (Element)elementArray.next();
                iOException = this.findCompilationUnitName((Element)object5);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : object5.getAnnotation(NbBundle.Messages.class).value()) {
                    if (string.startsWith("#")) {
                        arrayList.add(string);
                        if (!string.matches("# +(PART)?(NO)?I18N *")) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "#NOI18N and related keywords must not include spaces", (Element)object5);
                        continue;
                    }
                    int n = string.indexOf(61);
                    if (n == -1) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Bad key=value: " + string, (Element)object5);
                        continue;
                    }
                    object4 = string.substring(0, n);
                    if (((String)object4).isEmpty() || !((String)object4).equals(((String)object4).trim())) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Whitespace not permitted in key: " + string, (Element)object5);
                        continue;
                    }
                    Element element = (Element)hashMap2.put(this.toIdentifier((String)object4), object5);
                    if (element != null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + (String)object4, (Element)object5);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + (String)object4, element);
                        continue block23;
                    }
                    stringArray = string.substring(n + 1);
                    cloneable.put(object4, stringArray);
                    hashMap3.put((String)object4, iOException);
                    if (arrayList.isEmpty()) continue;
                    hashMap4.put((String)object4, arrayList.toArray(new String[0]));
                    arrayList.clear();
                }
                if (arrayList.isEmpty()) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Comments must precede keys", (Element)object5);
            }
            elementArray = new HashSet(hashMap2.values()).toArray(new Element[0]);
            try {
                Object object6;
                object5 = new EditableProperties(true);
                try {
                    iOException = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, (CharSequence)object3, "Bundle.properties").openInputStream();
                    try {
                        ((EditableProperties)object5).load((InputStream)iOException);
                    }
                    finally {
                        ((InputStream)iOException).close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                for (String string : ((AbstractMap)object5).keySet()) {
                    if (!cloneable.containsKey(string)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Key " + string + " is a duplicate of one from Bundle.properties", (Element)hashMap2.get(this.toIdentifier(string)));
                }
                try {
                    iOException = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, (CharSequence)object3, "Bundle.properties").openInputStream();
                    try {
                        EditableProperties editableProperties = new EditableProperties(true);
                        editableProperties.load((InputStream)iOException);
                        ((AbstractMap)object5).putAll(editableProperties);
                    }
                    finally {
                        ((InputStream)iOException).close();
                    }
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                ((AbstractMap)object5).putAll(cloneable);
                for (Map.Entry entry2 : hashMap4.entrySet()) {
                    ((EditableProperties)object5).setComment((String)entry2.getKey(), (String[])entry2.getValue(), false);
                }
                iOException = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, (CharSequence)object3, "Bundle.properties", elementArray).openOutputStream();
                try {
                    ((EditableProperties)object5).store((OutputStream)iOException);
                }
                finally {
                    ((OutputStream)iOException).close();
                }
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (Map.Entry entry3 : cloneable.entrySet()) {
                    String string;
                    Object object7;
                    String string2 = (String)entry3.getKey();
                    String string3 = (String)entry3.getValue();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("    /**\n");
                    object4 = new ArrayList();
                    int n = 0;
                    while (string3.contains("{" + n)) {
                        object4.add("arg" + n++);
                    }
                    stringArray = (String[])hashMap4.get(string2);
                    if (stringArray != null) {
                        for (String string4 : stringArray) {
                            object7 = Pattern.compile("# [{](\\d+)[}] - (.+)").matcher(string4);
                            if (!((Matcher)object7).matches()) continue;
                            n = Integer.parseInt(((Matcher)object7).group(1));
                            while (n >= object4.size()) {
                                object4.add("arg" + object4.size());
                            }
                            string = ((Matcher)object7).group(2);
                            object4.set(n, this.toIdentifier(string));
                            stringBuilder.append("     * @param ").append((String)object4.get(n)).append(" ").append(this.toJavadoc(string)).append("\n");
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer("<i>");
                    Matcher matcher = Pattern.compile("[{](\\d+)[}]").matcher(this.toJavadoc(string3));
                    while (matcher.find()) {
                        n = Integer.parseInt(matcher.group(1));
                        matcher.appendReplacement(stringBuffer, n < object4.size() ? "</i>{@code " + (String)object4.get(n) + "}<i>" : matcher.group());
                    }
                    matcher.appendTail(stringBuffer);
                    stringBuffer.append("</i>");
                    stringBuilder.append("     * @return ").append(stringBuffer.toString().replace("<i></i>", "")).append('\n');
                    stringBuilder.append("     * @see ").append((String)hashMap3.get(string2)).append('\n');
                    stringBuilder.append("     */\n");
                    String string5 = this.toIdentifier(string2);
                    stringBuilder.append("    static String ").append(string5).append("(");
                    boolean bl = true;
                    n = 0;
                    object7 = object4.iterator();
                    while (object7.hasNext()) {
                        string = (String)object7.next();
                        if (string.equals("arg" + n)) {
                            this.warnUndocumented(n, (Element)hashMap2.get(string5), string2);
                        }
                        ++n;
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("Object ").append(string);
                    }
                    stringBuilder.append(") {\n");
                    stringBuilder.append("        return org.openide.util.NbBundle.getMessage(Bundle.class, \"").append(string2).append("\"");
                    object7 = object4.iterator();
                    while (object7.hasNext()) {
                        string = (String)object7.next();
                        stringBuilder.append(", ").append(string);
                    }
                    stringBuilder.append(");\n");
                    stringBuilder.append("    }\n");
                    treeMap.put(string5, stringBuilder.toString());
                }
                try {
                    object6 = new TreeSet();
                    Matcher matcher = Pattern.compile("    /[*][*]\r?\n(?:     [*].+\r?\n)+     [*] @see (?:[\\w-]+)\r?\n     [*]/\r?\n    static String (\\w+).+\r?\n        .+\r?\n    [}]\r?\n").matcher(this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, (CharSequence)object3, "Bundle.java").getCharContent(false));
                    while (matcher.find()) {
                        String string = matcher.group(1);
                        if (treeMap.containsKey(string)) continue;
                        treeMap.put(string, matcher.group());
                        object6.add(string);
                    }
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                object6 = (String)object3 + ".Bundle";
                try (Writer writer = this.processingEnv.getFiler().createSourceFile((CharSequence)object6, elementArray).openWriter();){
                    PrintWriter printWriter = new PrintWriter(writer);
                    printWriter.println("package " + (String)object3 + ";");
                    printWriter.println("/** Localizable strings for {@link " + (String)object3 + "}. */");
                    printWriter.println("class Bundle {");
                    for (String string : treeMap.values()) {
                        printWriter.print(string);
                    }
                    printWriter.println("    private Bundle() {}");
                    printWriter.println("}");
                    printWriter.flush();
                    printWriter.close();
                }
            }
            catch (IOException iOException5) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate files: " + iOException5, elementArray[0]);
            }
        }
        return true;
    }

    private String findPackage(Element element) {
        switch (element.getKind()) {
            case PACKAGE: {
                return ((PackageElement)element).getQualifiedName().toString();
            }
        }
        return this.findPackage(element.getEnclosingElement());
    }

    private String findCompilationUnitName(Element element) {
        switch (element.getKind()) {
            case PACKAGE: {
                return "package-info";
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                return element.getSimpleName().toString();
            }
        }
        if ("RECORD".equals(element.getKind().name()) && element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return element.getSimpleName().toString();
        }
        return this.findCompilationUnitName(element.getEnclosingElement());
    }

    private String toIdentifier(String string) {
        if (BaseUtilities.isJavaIdentifier(string)) {
            return string;
        }
        String string2 = string.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (BaseUtilities.isJavaIdentifier(string2)) {
            return string2;
        }
        return "_" + string2;
    }

    private String toJavadoc(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace("*/", "&#x2A;/").replace("\n", "<br>").replace("@", "&#64;");
    }

    private void addToAnnotatedElements(Collection<? extends Element> collection, Set<Element> set) {
        for (Element element : collection) {
            if (element.getAnnotation(NbBundle.Messages.class) != null) {
                set.add(element);
            }
            if (element.getKind() == ElementKind.PACKAGE) continue;
            this.addToAnnotatedElements(element.getEnclosedElements(), set);
        }
    }

    private void warnUndocumented(int n, Element element, String string) {
        AnnotationMirror annotationMirror = null;
        AnnotationValue annotationValue = null;
        if (element != null) {
            block0: for (AnnotationMirror annotationMirror2 : element.getAnnotationMirrors()) {
                if (!annotationMirror2.getAnnotationType().toString().equals(NbBundle.Messages.class.getCanonicalName())) continue;
                annotationMirror = annotationMirror2;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                    Object object = entry.getValue().getValue();
                    if (object instanceof String) {
                        if (!((String)object).startsWith(string + "=")) break block0;
                        annotationValue = entry.getValue();
                        break block0;
                    }
                    for (AnnotationValue annotationValue2 : NbCollections.checkedListByCopy((List)object, AnnotationValue.class, true)) {
                        object = annotationValue2.getValue();
                        if (!(object instanceof String) || !((String)object).startsWith(string + "=")) continue;
                        annotationValue = annotationValue2;
                        break block0;
                    }
                }
            }
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Undocumented format parameter {" + n + "} prepend line: # {" + n + "} - some text,", element, annotationMirror, annotationValue);
    }
}

