/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RefreshSlow;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;

public final class FileObjectFactory {
    public static final Map<File, FileObjectFactory> AllFactories = new HashMap<File, FileObjectFactory>();
    public static boolean WARNINGS = true;
    final Map<Integer, Object> allIBaseFileObjects = new WeakHashMap<Integer, Object>();
    final ReadWriteLock allIBaseLock = new ReentrantReadWriteLock();
    private BaseFileObj root;
    private static final Logger LOG_REFRESH = Logger.getLogger("org.netbeans.modules.masterfs.REFRESH");

    private FileObjectFactory(File file) {
        this(new FileInfo(file));
    }

    private FileObjectFactory(FileInfo fileInfo) {
        this(fileInfo, null);
    }

    private FileObjectFactory(FileInfo fileInfo, Object object) {
        BaseFileObj baseFileObj = this.create(fileInfo);
        if (baseFileObj == null) {
            Logger.getLogger(FileObjectFactory.class.getName()).log(Level.SEVERE, "No fo for " + fileInfo + " queried for " + object, new NullPointerException());
        }
        assert (baseFileObj != null) : "No fo for " + fileInfo + " queried for " + object;
        this.root = baseFileObj;
    }

    public static FileObjectFactory getInstance(File file) {
        return FileObjectFactory.getInstance(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObjectFactory getInstance(File file, boolean bl) {
        FileObjectFactory fileObjectFactory = null;
        FileInfo fileInfo = new FileInfo(file).getRoot();
        File file2 = fileInfo.getFile();
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            fileObjectFactory = AllFactories.get(file2);
        }
        if (fileObjectFactory == null && bl && fileInfo.isConvertibleToFileObject()) {
            map = AllFactories;
            synchronized (map) {
                fileObjectFactory = AllFactories.get(file2);
                if (fileObjectFactory == null) {
                    fileObjectFactory = new FileObjectFactory(new FileInfo(file2), file);
                    AllFactories.put(file2, fileObjectFactory);
                }
            }
        }
        return fileObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileObjectFactory> getInstances() {
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            return new ArrayList<FileObjectFactory>(AllFactories.values());
        }
    }

    public final BaseFileObj getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFactoriesSize() {
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            return AllFactories.size();
        }
    }

    private List<FileObject> existingFileObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.allIBaseLock.readLock().lock();
        try {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        finally {
            this.allIBaseLock.readLock().unlock();
        }
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        for (Object e : arrayList) {
            Collection collection = e instanceof Reference ? Collections.singleton(e) : (List)e;
            for (Object e2 : collection) {
                Reference reference = (Reference)e2;
                Object var9_10 = reference == null ? null : reference.get();
                if (!(var9_10 instanceof FileObject)) continue;
                arrayList2.add(var9_10);
            }
        }
        return arrayList2;
    }

    public int getSize() {
        List<FileObject> list = this.existingFileObjects();
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFileObj getFileObject(FileInfo fileInfo, Caller caller, boolean bl) {
        int n;
        File file = fileInfo.getFile();
        FolderObj folderObj = BaseFileObj.getExistingParentFor(file, this);
        FileNaming fileNaming = null;
        boolean bl2 = true;
        if (folderObj != null) {
            ChildrenCache childrenCache = folderObj.getChildrenCache();
            Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
            Runnable[] runnableArray = new Runnable[1];
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    if (runnableArray[0] == null) break;
                    runnableArray[0].run();
                }
                privileged.enterReadAccess();
                try {
                    String string = BaseFileObj.getNameExt(file);
                    bl2 = childrenCache.isCacheInitialized();
                    fileNaming = childrenCache.getChild(string, false, runnableArray);
                    continue;
                }
                finally {
                    privileged.exitReadAccess();
                }
            }
        }
        int n2 = bl2 ? -1 : (n = fileNaming != null ? 1 : 0);
        if (n == -1 && FileBasedFileSystem.isModificationInProgress()) {
            n = file.exists() ? 1 : 0;
        }
        return this.issueIfExist(file, caller, folderObj, fileNaming, n, caller.asynchFire(), bl);
    }

    private boolean checkCacheState(boolean bl, File file, Caller caller) {
        if (!(bl || caller != Caller.GetParent && caller != Caller.ToFileObject)) {
            return true;
        }
        if (this.isWarningEnabled() && caller != null && caller != Caller.GetChildern) {
            boolean bl2;
            boolean bl3 = file.exists();
            boolean bl4 = bl2 = bl != bl3;
            if (bl2) {
                File[] fileArray;
                File file2;
                if (!bl3 && (file2 = file.getParentFile()) != null && (fileArray = file2.listFiles()) != null && Arrays.asList(fileArray).contains(file)) {
                    return true;
                }
                this.printWarning(file);
            }
        }
        return true;
    }

    private Integer initRealExists(int n) {
        Integer n2 = new Integer(n);
        return n2;
    }

    private void printWarning(File file) {
        StringBuilder stringBuilder = new StringBuilder("WARNING(please REPORT):  Externally ");
        stringBuilder.append(file.exists() ? "created " : "deleted ");
        stringBuilder.append(file.isDirectory() ? "folder: " : "file: ");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append(" (Possibly not refreshed FileObjects when external command finished.");
        stringBuilder.append(" For additional information see: http://wiki.netbeans.org/wiki/view/FileSystems)");
        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, illegalStateException.getMessage(), illegalStateException);
    }

    private BaseFileObj issueIfExist(File file, Caller caller, FileObject fileObject, FileNaming fileNaming, int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        BaseFileObj baseFileObj = null;
        Integer n2 = this.initRealExists(n);
        FileChangedManager fileChangedManager = FileChangedManager.getInstance();
        baseFileObj = this.getCachedOnly(file);
        if (caller == Caller.Refresh && baseFileObj != null && !baseFileObj.isValid()) {
            fileChangedManager.impeachExistence(file, true);
            baseFileObj = null;
        }
        if (fileObject != null && fileObject.isValid()) {
            if (fileNaming != null) {
                if (baseFileObj == null) {
                    boolean bl4 = bl3 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl3) && !(bl3 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(true, file, caller));
                } else if (baseFileObj.isValid()) {
                    boolean bl5 = bl3 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl3) && !(bl3 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl3, file, caller));
                } else {
                    bl3 = FileObjectFactory.touchExists(file, n2);
                    if (!bl3 && !Files.isSymbolicLink(file.toPath())) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                }
            } else if (baseFileObj == null) {
                boolean bl6 = bl3 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl3) && bl3 != FileObjectFactory.touchExists(file, n2)) {
                    bl3 = !bl3;
                    this.refreshFromGetter(fileObject, bl);
                }
                assert (this.checkCacheState(bl3, file, caller));
            } else if (baseFileObj.isValid()) {
                bl3 = FileObjectFactory.touchExists(file, n2);
                if (!bl3) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            } else {
                bl3 = FileObjectFactory.touchExists(file, n2);
                if (bl3) {
                    this.refreshFromGetter(fileObject, bl);
                }
            }
        } else if (baseFileObj == null) {
            bl3 = caller == Caller.GetParent ? true : FileObjectFactory.touchExists(file, n2);
        } else if (baseFileObj.isValid()) {
            if (fileObject == null) {
                boolean bl7 = bl3 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl3) && !(bl3 = FileObjectFactory.touchExists(file, n2))) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
                assert (this.checkCacheState(bl3, file, caller));
            } else {
                bl3 = FileObjectFactory.touchExists(file, n2);
                if (!bl3) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            }
        } else {
            boolean bl8 = bl3 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
            if (fileChangedManager.impeachExistence(file, bl3)) {
                bl3 = FileObjectFactory.touchExists(file, n2);
            }
            assert (this.checkCacheState(bl3, file, caller));
        }
        if (!bl3) {
            switch (caller) {
                case GetParent: {
                    BaseFileObj baseFileObj2 = null;
                    baseFileObj2 = baseFileObj != null && !baseFileObj.isRoot() ? baseFileObj : this.getOrCreate(new FileInfo(file, 1));
                    if (baseFileObj2 instanceof BaseFileObj && baseFileObj2.isValid() && !(bl3 = FileObjectFactory.touchExists(file, n2))) {
                        this.invalidateSubtree(baseFileObj2, false, false);
                    }
                    assert (this.checkCacheState(bl3, file, caller));
                    return baseFileObj2;
                }
                case ToFileObject: {
                    bl3 = FileObjectFactory.touchExists(file, n2);
                    if (bl3 && fileObject != null && fileObject.isValid()) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl3, file, caller));
                    break;
                }
            }
        }
        if (bl2) {
            return bl3 ? this.getOrCreate(new FileInfo(file, 1)) : null;
        }
        BaseFileObj baseFileObj3 = this.getOrCreate(new FileInfo(file, 1));
        if (!bl3) {
            baseFileObj3.setValid(false);
        }
        return baseFileObj3;
    }

    private static boolean touchExists(File file, Integer n) {
        if (n == -1) {
            n = FileChangedManager.getInstance().exists(file) ? 1 : 0;
        }
        assert (n != -1);
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj getOrCreate(FileInfo fileInfo) {
        Object object;
        boolean bl;
        BaseFileObj baseFileObj = null;
        File file = fileInfo.getFile();
        boolean bl2 = bl = fileInfo.isWindows() && file.getName().endsWith(".") && !file.getName().matches("[.]{1,2}");
        if (bl) {
            object = FileUtil.normalizeFile((File)file);
            boolean bl3 = bl = !object.getName().endsWith(".");
            if (bl) {
                return null;
            }
        }
        this.allIBaseLock.writeLock().lock();
        try {
            baseFileObj = this.getCachedOnly(file);
            if (baseFileObj == null || !baseFileObj.isValid()) {
                object = file.getParentFile();
                baseFileObj = object != null ? this.create(fileInfo) : this.getRoot();
            }
            object = baseFileObj;
            return object;
        }
        finally {
            this.allIBaseLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateSubtree(BaseFileObj baseFileObj, boolean bl, boolean bl2) {
        ArrayList<BaseFileObj> arrayList = bl ? new ArrayList<BaseFileObj>() : Collections.emptyList();
        this.allIBaseLock.writeLock().lock();
        try {
            for (FileNaming object : NamingFactory.findSubTree(baseFileObj.getFileName())) {
                BaseFileObj baseFileObj2 = this.getCachedOnly(object.getFile());
                if (baseFileObj2 == null || !baseFileObj2.isValid()) continue;
                baseFileObj2.invalidateFO(false, bl2, false);
                if (!bl) continue;
                arrayList.add(baseFileObj2);
            }
        }
        finally {
            this.allIBaseLock.writeLock().unlock();
        }
        for (BaseFileObj baseFileObj3 : arrayList) {
            baseFileObj3.notifyDeleted(bl2);
        }
    }

    public final String dumpObjects() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FileObject fileObject : this.existingFileObjects()) {
            stringBuilder.append(fileObject).append("\n");
        }
        return stringBuilder.toString();
    }

    private BaseFileObj create(FileInfo fileInfo) {
        if (!fileInfo.isConvertibleToFileObject()) {
            return null;
        }
        File file = fileInfo.getFile();
        FileNaming fileNaming = fileInfo.getFileNaming();
        FileNaming fileNaming2 = fileNaming = fileNaming == null ? NamingFactory.fromFile(file) : fileNaming;
        if (fileNaming == null) {
            return null;
        }
        if (fileNaming.isFile() && !fileNaming.isDirectory()) {
            FileObj fileObj = new FileObj(file, fileNaming);
            return this.putInCache(fileObj, fileObj.getFileName().getId());
        }
        if (!fileNaming.isFile() && fileNaming.isDirectory()) {
            FolderObj folderObj = new FolderObj(file, fileNaming);
            return this.putInCache(folderObj, folderObj.getFileName().getId());
        }
        assert (false);
        return null;
    }

    final void refreshAll(RefreshSlow refreshSlow, boolean bl, boolean bl2) {
        Set<BaseFileObj> set = this.collectForRefresh(bl);
        this.refresh(set, refreshSlow, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BaseFileObj> collectForRefresh(boolean bl) {
        WeakSet weakSet;
        this.allIBaseLock.writeLock().lock();
        try {
            weakSet = new WeakSet(this.allIBaseFileObjects.size() * 3 + 11);
            for (Object object : this.allIBaseFileObjects.values()) {
                Object object22;
                if (object instanceof List) {
                    for (Object object22 : (List)object) {
                        BaseFileObj baseFileObj = this.shallBeChecked(object22 != null ? (BaseFileObj)((Object)((Reference)object22).get()) : null, bl);
                        if (baseFileObj == null) continue;
                        weakSet.add(baseFileObj);
                    }
                    continue;
                }
                WeakReference weakReference = (WeakReference)object;
                object22 = this.shallBeChecked(weakReference != null ? (BaseFileObj)((Object)weakReference.get()) : null, bl);
                if (object22 == null) continue;
                weakSet.add(object22);
            }
        }
        finally {
            this.allIBaseLock.writeLock().unlock();
        }
        weakSet.remove((Object)this.root);
        return weakSet;
    }

    private BaseFileObj shallBeChecked(BaseFileObj baseFileObj, boolean bl) {
        FolderObj folderObj;
        if (baseFileObj != null && bl && (folderObj = (FolderObj)(baseFileObj instanceof FolderObj ? baseFileObj : baseFileObj.getExistingParent())) != null && Watcher.isWatched(baseFileObj)) {
            LOG_REFRESH.log(Level.FINER, "skip: {0}", (Object)baseFileObj);
            baseFileObj = null;
        }
        return baseFileObj;
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, File ... fileArray) {
        return this.refresh(set, refreshSlow, true, fileArray);
    }

    private static boolean isInFiles(BaseFileObj baseFileObj, File[] fileArray) {
        if (baseFileObj == null) {
            return false;
        }
        if (fileArray == null) {
            return true;
        }
        for (File file : fileArray) {
            if (!FileObjectFactory.isParentOf(file, baseFileObj.getFileName().getFile())) continue;
            return true;
        }
        return false;
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, boolean bl) {
        return this.refresh(set, refreshSlow, bl, null);
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, boolean bl, File[] fileArray) {
        int n = 0;
        Iterator<BaseFileObj> iterator = set.iterator();
        while (iterator.hasNext()) {
            BaseFileObj baseFileObj;
            BaseFileObj baseFileObj2 = null;
            if (refreshSlow != null && (baseFileObj = refreshSlow.preferrable()) != null && set.remove((Object)baseFileObj)) {
                LOG_REFRESH.log(Level.FINER, "Preferring {0}", (Object)baseFileObj);
                baseFileObj2 = baseFileObj;
                iterator = set.iterator();
            }
            if (baseFileObj2 == null) {
                baseFileObj2 = iterator.next();
                iterator.remove();
            }
            ++n;
            if (!FileObjectFactory.isInFiles(baseFileObj2, fileArray)) continue;
            if (refreshSlow != null) {
                if (!refreshSlow.refreshFileObject(baseFileObj2, bl, n)) {
                    return false;
                }
                n = 0;
                continue;
            }
            baseFileObj2.refresh(bl);
        }
        return true;
    }

    public static boolean isParentOf(File file, File file2) {
        File file3;
        for (file3 = file2; file3 != null && !Utils.equals(file3, file); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename(Set<BaseFileObj> set) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        this.allIBaseLock.writeLock().lock();
        try {
            Object object5;
            Object object2;
            Integer n;
            for (Map.Entry<Integer, Object> object3 : this.allIBaseFileObjects.entrySet()) {
                Object object4 = object3.getValue();
                n = object3.getKey();
                if (!(object4 instanceof List)) {
                    object2 = (WeakReference)object4;
                    object5 = object2 != null ? (BaseFileObj)((Object)((Reference)object2).get()) : null;
                    if (!set.contains(object5)) continue;
                    hashMap.put(n, object5);
                    continue;
                }
                for (Object object5 : (List)object4) {
                    BaseFileObj baseFileObj = object5 != null ? (BaseFileObj)((Object)((Reference)object5).get()) : null;
                    if (!set.contains((Object)baseFileObj)) continue;
                    hashMap.put(n, object5);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                n = (Integer)entry.getKey();
                object2 = this.allIBaseFileObjects.remove(n);
                if (object2 instanceof List) {
                    object5 = (List)object2;
                    object5.remove(entry.getValue());
                    this.allIBaseFileObjects.put(n, object2);
                    continue;
                }
                object5 = (BaseFileObj)((Object)entry.getValue());
                this.putInCache((BaseFileObj)((Object)object5), object5.getFileName().getId());
            }
        }
        finally {
            this.allIBaseLock.writeLock().unlock();
        }
    }

    public final BaseFileObj getCachedOnly(File file) {
        return this.getCachedOnly(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseFileObj getCachedOnly(File file, boolean bl) {
        BaseFileObj baseFileObj;
        Integer n = NamingFactory.createID(file);
        this.allIBaseLock.readLock().lock();
        try {
            Object object = this.allIBaseFileObjects.get(n);
            baseFileObj = object instanceof Reference ? FileObjectFactory.getReference(Collections.nCopies(1, object), file) : FileObjectFactory.getReference((List)object, file);
        }
        finally {
            this.allIBaseLock.readLock().unlock();
        }
        if (baseFileObj != null && bl && !file.getName().equals(baseFileObj.getNameExt()) && !Utils.equals(file, baseFileObj.getFileName().getFile())) {
            baseFileObj = null;
        }
        return baseFileObj;
    }

    private static BaseFileObj getReference(List<?> list, File file) {
        BaseFileObj baseFileObj = null;
        if (list != null) {
            for (int i = 0; baseFileObj == null && i < list.size(); ++i) {
                BaseFileObj baseFileObj2;
                Object t;
                Object obj = list.get(i);
                if (!(obj instanceof Reference) || !((t = ((Reference)obj).get()) instanceof BaseFileObj) || (baseFileObj2 = (BaseFileObj)((Object)t)) == null || baseFileObj2.getFileName().getFile().compareTo(file) != 0) continue;
                baseFileObj = baseFileObj2;
            }
        }
        return baseFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj putInCache(BaseFileObj baseFileObj, Integer n) {
        this.allIBaseLock.writeLock().lock();
        try {
            WeakReference<BaseFileObj> weakReference = new WeakReference<BaseFileObj>(baseFileObj);
            WeakReference<BaseFileObj> weakReference2 = this.allIBaseFileObjects.put(n, weakReference);
            if (weakReference2 != null) {
                if (weakReference2 instanceof List) {
                    List list = (List)((Object)weakReference2);
                    list.add(weakReference);
                    this.allIBaseFileObjects.put(n, weakReference2);
                } else {
                    BaseFileObj baseFileObj2;
                    assert (weakReference2 instanceof WeakReference);
                    Reference reference = weakReference2;
                    BaseFileObj baseFileObj3 = baseFileObj2 = reference != null ? (BaseFileObj)((Object)reference.get()) : null;
                    if (baseFileObj2 != null && !baseFileObj.getFileName().equals(baseFileObj2.getFileName())) {
                        ArrayList<Reference> arrayList = new ArrayList<Reference>();
                        arrayList.add(reference);
                        arrayList.add(weakReference);
                        this.allIBaseFileObjects.put(n, arrayList);
                    }
                }
            }
        }
        finally {
            this.allIBaseLock.writeLock().unlock();
        }
        return baseFileObj;
    }

    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.allIBaseLock.readLock().lock();
        try {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        finally {
            this.allIBaseLock.readLock().unlock();
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Reference reference : arrayList) {
            FileObject fileObject = reference != null ? (FileObject)reference.get() : null;
            if (fileObject == null) continue;
            arrayList2.add(fileObject.getPath());
        }
        return ((Object)arrayList2).toString();
    }

    public static synchronized Map<File, FileObjectFactory> factories() {
        return new HashMap<File, FileObjectFactory>(AllFactories);
    }

    public boolean isWarningEnabled() {
        return WARNINGS && !BaseUtilities.isMac();
    }

    public static void reinitForTests() {
        AllFactories.clear();
    }

    public final BaseFileObj getValidFileObject(File file, Caller caller, boolean bl) {
        BaseFileObj baseFileObj = this.getFileObject(new FileInfo(file), caller, bl);
        if (bl) {
            return baseFileObj != null && baseFileObj.isValid() ? baseFileObj : null;
        }
        return baseFileObj;
    }

    public void refresh(boolean bl) {
        this.refresh(null, bl);
    }

    void refresh(RefreshSlow refreshSlow, boolean bl) {
        this.refresh(refreshSlow, false, bl);
    }

    final void refresh(final RefreshSlow refreshSlow, final boolean bl, final boolean bl2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileObjectFactory.this.refreshAll(refreshSlow, bl, bl2);
            }
        };
        stopWatch.start();
        try {
            if (refreshSlow != null) {
                FileBasedFileSystem.runAsInconsistent(runnable);
            } else {
                FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileBasedFileSystem.runAsInconsistent(runnable);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        if (LOG_REFRESH.isLoggable(Level.FINE)) {
            LOG_REFRESH.log(Level.FINE, "FS.refresh statistics ({0}FileObjects):\n  {1}\n  {2}\n  {3}\n  {4}\n", new Object[]{Statistics.fileObjects(), Statistics.REFRESH_FS.toString(), Statistics.LISTENERS_CALLS.toString(), Statistics.REFRESH_FOLDER.toString(), Statistics.REFRESH_FILE.toString()});
        }
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    final void refreshFor(final RefreshSlow refreshSlow, final boolean bl, final File ... fileArray) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Set set = FileObjectFactory.this.collectForRefresh(bl);
                FileObjectFactory.this.refresh((Set<BaseFileObj>)set, refreshSlow, fileArray);
                if (LOG_REFRESH.isLoggable(Level.FINER)) {
                    LOG_REFRESH.log(Level.FINER, "Refresh for {0} objects", set.size());
                    for (BaseFileObj baseFileObj : set) {
                        LOG_REFRESH.log(Level.FINER, "  {0}", (Object)baseFileObj);
                    }
                }
            }
        };
        stopWatch.start();
        try {
            if (refreshSlow != null) {
                FileBasedFileSystem.runAsInconsistent(runnable);
            } else {
                FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileBasedFileSystem.runAsInconsistent(runnable);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        if (LOG_REFRESH.isLoggable(Level.FINE)) {
            LOG_REFRESH.log(Level.FINE, "FS.refresh statistics ({0}FileObjects):\n  {1}\n  {2}\n  {3}\n  {4}\n", new Object[]{Statistics.fileObjects(), Statistics.REFRESH_FS.toString(), Statistics.LISTENERS_CALLS.toString(), Statistics.REFRESH_FOLDER.toString(), Statistics.REFRESH_FILE.toString()});
        }
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    private void refreshFromGetter(FileObject fileObject, boolean bl) {
        try {
            if (bl) {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new AsyncRefreshAtomicAction(fileObject));
            } else {
                fileObject.refresh();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static class AsyncRefreshAtomicAction
    implements FileSystem.AtomicAction {
        private FileObject fo;

        AsyncRefreshAtomicAction(FileObject fileObject) {
            this.fo = fileObject;
        }

        public void run() throws IOException {
            this.fo.refresh();
        }
    }

    public static enum Caller {
        ToFileObject,
        GetFileObject,
        GetChildern,
        GetParent,
        Refresh,
        Others;


        boolean asynchFire() {
            return this != Refresh && this != Others;
        }
    }
}

