/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.warmup;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;
import org.openide.util.NbBundle;

public final class DiagnosticTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DiagnosticTask.class.getName());
    private static boolean executed;

    @Override
    public void run() {
        if (executed) {
            return;
        }
        String string = this.logParams();
        LOG.info(string);
        this.logEnv();
        if (Boolean.getBoolean("netbeans.full.hack")) {
            LOG.info("Using netbeans.full.hack=true; see http://wiki.netbeans.org/DevFaqNetBeansFullHack");
        }
        executed = true;
    }

    private void logEnv() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            long l = (Long)mBeanServer.getAttribute(operatingSystemMXBean.getObjectName(), "TotalPhysicalMemorySize");
            LOG.log(Level.INFO, "Total memory {0}", l);
            LogRecord logRecord = new LogRecord(Level.INFO, "MEMORY");
            logRecord.setResourceBundle(NbBundle.getBundle(DiagnosticTask.class));
            logRecord.setParameters(new Object[]{l});
            Logger.getLogger("org.netbeans.ui.performance").log(logRecord);
        }
        catch (SecurityException securityException) {
            LOG.log(Level.INFO, null, securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.INFO, null, illegalArgumentException);
        }
        catch (MBeanException mBeanException) {
            LOG.log(Level.INFO, null, mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            LOG.log(Level.INFO, null, attributeNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            LOG.log(Level.INFO, null, instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            LOG.log(Level.INFO, null, reflectionException);
        }
    }

    private void logMemoryUsage(StringBuilder stringBuilder, MemoryUsage memoryUsage, String string) {
        long l = memoryUsage.getInit();
        long l2 = memoryUsage.getMax();
        stringBuilder.append(string).append(" usage: initial ").append(this.formatBytes(l)).append(" maximum ").append(this.formatBytes(l2)).append('\n');
    }

    private String formatBytes(long l) {
        if (l > 0x100000L) {
            return MessageFormat.format("{0,number,0.0MB}", (double)l / 1024.0 / 1024.0);
        }
        if (l > 1024L) {
            return MessageFormat.format("{0,number,0.0kB}", (double)l / 1024.0);
        }
        return MessageFormat.format("{0,number,0b}", l);
    }

    private String formatTime(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l > 86400000L) {
            stringBuilder.append(MessageFormat.format("{0,number,0d}", l / 86400000L));
            l %= 86400000L;
        }
        if (l > 3600000L || stringBuilder.length() > 0) {
            stringBuilder.append(MessageFormat.format("{0,number,0h}", l / 3600000L));
            l %= 3600000L;
        }
        if (l > 60000L || stringBuilder.length() > 0) {
            stringBuilder.append(MessageFormat.format("{0,number,0m}", l / 60000L));
            l %= 60000L;
        }
        stringBuilder.append(MessageFormat.format("{0,number,0s}", l / 1000L));
        return stringBuilder.toString();
    }

    private String logParams() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("Diagnostic information\n");
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
            stringBuilder.append("Input arguments:");
            for (String object : runtimeMXBean.getInputArguments()) {
                stringBuilder.append("\n\t").append(object);
            }
            if (compilationMXBean != null) {
                stringBuilder.append("\nCompiler: " + compilationMXBean.getName()).append('\n');
            }
            Object object = memoryMXBean.getHeapMemoryUsage();
            this.logMemoryUsage(stringBuilder, (MemoryUsage)object, "Heap memory");
            object = memoryMXBean.getNonHeapMemoryUsage();
            this.logMemoryUsage(stringBuilder, (MemoryUsage)object, "Non heap memory");
            for (GarbageCollectorMXBean l : ManagementFactory.getGarbageCollectorMXBeans()) {
                stringBuilder.append("Garbage collector: ").append(l.getName()).append(" (Collections=").append(l.getCollectionCount()).append(" Total time spent=").append(this.formatTime(l.getCollectionTime())).append(")\n");
            }
            int n = classLoadingMXBean.getLoadedClassCount();
            long l = classLoadingMXBean.getTotalLoadedClassCount();
            long l2 = classLoadingMXBean.getUnloadedClassCount();
            stringBuilder.append("Classes: loaded=").append(n).append(" total loaded=").append(l).append(" unloaded ").append(l2).append('\n');
        }
        catch (NullPointerException nullPointerException) {
            LOG.log(Level.WARNING, null, nullPointerException);
        }
        return stringBuilder.toString();
    }
}

