/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.charts;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.charts.ColorFactory;

public final class SimpleXYChartDescriptor {
    private final int chartType;
    private final long minValue;
    private final long maxValue;
    private final long initialYMargin;
    private final boolean hideableItems;
    private final double chartFactor;
    private final NumberFormat customFormat;
    private final int valuesBuffer;
    private final List<String> itemNames = new ArrayList<String>();
    private final List<Color> itemColors = new ArrayList<Color>();
    private final List<Float> lineWidths = new ArrayList<Float>();
    private final List<Color> lineColors = new ArrayList<Color>();
    private final List<Color> fillColors1 = new ArrayList<Color>();
    private final List<Color> fillColors2 = new ArrayList<Color>();
    private String[] detailNames;
    private String chartTitle;
    private String xAxisDescription;
    private String yAxisDescription;
    private long limitYValue;

    public static SimpleXYChartDescriptor decimal(long initialYMargin, boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.decimal(initialYMargin, 1.0, hideableItems, valuesBuffer);
    }

    public static SimpleXYChartDescriptor decimal(long initialYMargin, double chartFactor, boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.decimal(0L, Long.MIN_VALUE, initialYMargin, chartFactor, hideableItems, valuesBuffer);
    }

    public static SimpleXYChartDescriptor decimal(long minValue, long maxValue, long initialYMargin, double chartFactor, boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.decimal(minValue, maxValue, initialYMargin, chartFactor, null, hideableItems, valuesBuffer);
    }

    public static SimpleXYChartDescriptor decimal(long minValue, long maxValue, long initialYMargin, double chartFactor, NumberFormat customFormat, boolean hideableItems, int valuesBuffer) {
        return new SimpleXYChartDescriptor(0, minValue, maxValue, initialYMargin, hideableItems, chartFactor, customFormat, valuesBuffer);
    }

    public static SimpleXYChartDescriptor bytes(long initialYMargin, boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.bytes(0L, Long.MIN_VALUE, initialYMargin, hideableItems, valuesBuffer);
    }

    public static SimpleXYChartDescriptor bytes(long minValue, long maxValue, long initialYMargin, boolean hideableItems, int valuesBuffer) {
        return new SimpleXYChartDescriptor(1, minValue, maxValue, initialYMargin, hideableItems, 1.0, null, valuesBuffer);
    }

    public static SimpleXYChartDescriptor bitsPerSec(long initialYMargin, boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.bitsPerSec(0L, Long.MIN_VALUE, initialYMargin, hideableItems, valuesBuffer);
    }

    public static SimpleXYChartDescriptor bitsPerSec(long minValue, long maxValue, long initialYMargin, boolean hideableItems, int valuesBuffer) {
        return new SimpleXYChartDescriptor(3, minValue, maxValue, initialYMargin, hideableItems, 1.0, null, valuesBuffer);
    }

    public static SimpleXYChartDescriptor percent(boolean hideableItems, int valuesBuffer) {
        return SimpleXYChartDescriptor.percent(hideableItems, 1.0, valuesBuffer);
    }

    public static SimpleXYChartDescriptor percent(boolean hideableItems, double chartFactor, int valuesBuffer) {
        return SimpleXYChartDescriptor.percent(0L, 100L, 100L, hideableItems, chartFactor, valuesBuffer);
    }

    public static SimpleXYChartDescriptor percent(long minValue, long maxValue, long initialYMargin, boolean hideableItems, double chartFactor, int valuesBuffer) {
        long max = (long)Math.ceil((double)maxValue / chartFactor);
        long init = (long)Math.ceil((double)initialYMargin / chartFactor);
        return new SimpleXYChartDescriptor(2, minValue, max, init, hideableItems, chartFactor, null, valuesBuffer);
    }

    public void addLineItems(String ... itemNames) {
        for (String itemName : itemNames) {
            Color color = this.getNextItemColor();
            this.addItem(itemName, color, 2.0f, color, null, null);
        }
    }

    public void addFillItems(String ... itemNames) {
        for (String itemName : itemNames) {
            Color[] gradients = this.getNextItemGradient();
            this.addItem(itemName, gradients[0], 2.0f, null, gradients[0], gradients[1]);
        }
    }

    public void addLineFillItems(String ... itemNames) {
        for (String itemName : itemNames) {
            Color color = this.getNextItemColor();
            Color[] gradients = this.getNextItemGradient();
            this.addItem(itemName, color, 2.0f, color, gradients[0], gradients[1]);
        }
    }

    public void addItem(String itemName, Color itemColor, float lineWidth, Color lineColor, Color fillColor1, Color fillColor2) {
        this.itemNames.add(itemName);
        this.itemColors.add(itemColor);
        this.lineWidths.add(Float.valueOf(lineWidth));
        this.lineColors.add(lineColor);
        this.fillColors1.add(fillColor1);
        this.fillColors2.add(fillColor2);
    }

    private Color getNextItemColor() {
        int newItemIndex = this.itemNames.size();
        int colorsCount = ColorFactory.getPredefinedColorsCount();
        Color color = null;
        if (newItemIndex >= colorsCount) {
            color = ColorFactory.getPredefinedColor(newItemIndex % colorsCount);
            int darkerFactor = newItemIndex / colorsCount;
            while (darkerFactor-- > 0) {
                color = color.darker();
            }
        } else {
            color = ColorFactory.getPredefinedColor(newItemIndex);
        }
        return color;
    }

    private Color[] getNextItemGradient() {
        int newItemIndex = this.itemNames.size();
        int colorsCount = ColorFactory.getPredefinedColorsCount();
        Color[] color = null;
        if (newItemIndex >= colorsCount) {
            color = ColorFactory.getPredefinedGradient(newItemIndex % colorsCount);
            int darkerFactor = newItemIndex / colorsCount;
            while (darkerFactor-- > 0) {
                color[0] = color[0].darker();
                color[1] = color[1].darker();
            }
        } else {
            color = ColorFactory.getPredefinedGradient(newItemIndex);
        }
        return color;
    }

    public void setDetailsItems(String[] detailNames) {
        this.detailNames = detailNames != null ? (String[])detailNames.clone() : null;
    }

    public void setLimitYValue(long limit) {
        this.limitYValue = limit;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public void setXAxisDescription(String xAxisDescription) {
        this.xAxisDescription = xAxisDescription;
    }

    public void setYAxisDescription(String yAxisDescription) {
        this.yAxisDescription = yAxisDescription;
    }

    int getChartType() {
        return this.chartType;
    }

    long getMinValue() {
        return this.minValue;
    }

    long getMaxValue() {
        return this.maxValue;
    }

    long getInitialYMargin() {
        return this.initialYMargin;
    }

    boolean areItemsHideable() {
        return this.hideableItems;
    }

    double getChartFactor() {
        return this.chartFactor;
    }

    NumberFormat getCustomFormat() {
        return this.customFormat;
    }

    int getValuesBuffer() {
        return this.valuesBuffer;
    }

    String[] getItemNames() {
        return this.itemNames.toArray(new String[0]);
    }

    Color[] getItemColors() {
        return this.itemColors.toArray(new Color[0]);
    }

    float[] getLineWidths() {
        if (this.lineWidths.isEmpty()) {
            return null;
        }
        float[] floats = new float[this.lineWidths.size()];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = this.lineWidths.get(i).floatValue();
        }
        return floats;
    }

    Color[] getLineColors() {
        return this.lineColors.isEmpty() ? null : this.lineColors.toArray(new Color[0]);
    }

    Color[] getFillColors1() {
        return this.fillColors1.isEmpty() ? null : this.fillColors1.toArray(new Color[0]);
    }

    Color[] getFillColors2() {
        return this.fillColors2.isEmpty() ? null : this.fillColors2.toArray(new Color[0]);
    }

    String[] getDetailsItems() {
        return this.detailNames;
    }

    String getChartTitle() {
        return this.chartTitle;
    }

    String getXAxisDescription() {
        return this.xAxisDescription;
    }

    String getYAxisDescription() {
        return this.yAxisDescription;
    }

    long getLimitYValue() {
        return this.limitYValue;
    }

    private SimpleXYChartDescriptor(int chartType, long minValue, long maxValue, long initialYMargin, boolean hideableItems, double chartFactor, NumberFormat customFormat, int valuesBuffer) {
        this.chartType = chartType;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.initialYMargin = initialYMargin;
        this.hideableItems = hideableItems;
        this.chartFactor = chartFactor;
        this.customFormat = customFormat;
        this.valuesBuffer = valuesBuffer;
    }
}

