/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectMergedFields;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectMergedReferences;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsWrapper;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TerminalJavaNodes;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;

public abstract class TruffleObjectPropertyProvider<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>, I>
extends HeapViewerNode.Provider {
    private final Class<O> objectClass;
    private final L language;
    private final String propertyName;
    private final int maxPropertyItems;
    private final boolean displaysProgress;
    private final boolean filtersProperties;

    protected TruffleObjectPropertyProvider(String propertyName, L language, boolean displaysProgress, boolean filtersProperties, int maxPropertyItems) {
        this.language = language;
        this.objectClass = ((TruffleLanguage)((Object)language)).getLanguageObjectClass();
        this.propertyName = propertyName;
        this.maxPropertyItems = maxPropertyItems;
        this.displaysProgress = displaysProgress;
        this.filtersProperties = filtersProperties;
    }

    public String getName() {
        return this.propertyName;
    }

    protected final L getLanguage() {
        return this.language;
    }

    public abstract boolean supportsView(Heap var1, String var2);

    public abstract boolean supportsNode(HeapViewerNode var1, Heap var2, String var3);

    protected abstract Collection<I> getPropertyItems(O var1) throws InterruptedException;

    protected boolean includeItem(I item) {
        return true;
    }

    protected abstract HeapViewerNode createNode(I var1, Heap var2);

    protected String getMergedPropertiesKey() {
        return null;
    }

    protected final boolean filtersProperties() {
        return this.filtersProperties;
    }

    protected final String moreNodesString(String moreNodesCount) {
        return Bundle.TruffleObjectPropertyProvider_MoreNodes(moreNodesCount, this.propertyName);
    }

    protected final String samplesContainerString(String objectsCount) {
        return Bundle.TruffleObjectPropertyProvider_SamplesContainer(objectsCount, this.propertyName);
    }

    protected final String nodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.TruffleObjectPropertyProvider_NodesContainer(firstNodeIdx, lastNodeIdx, this.propertyName);
    }

    public final HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        O object = this.getObject(parent, heap);
        return object == null ? null : this.getNodes(object, parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HeapViewerNode[] getNodes(O object, HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        Collection<I> itemsC = null;
        if (!this.displaysProgress) {
            itemsC = this.getPropertyItems(object);
        } else {
            HeapOperations.OpProgressHandle pHandle = new HeapOperations.OpProgressHandle(Bundle.TruffleObjectPropertyProvider_ComputingNodes(this.propertyName));
            pHandle.setInitialDelay(1000);
            pHandle.start(1000);
            pHandle.setProgress(0);
            try {
                itemsC = this.getPropertyItems(object);
            }
            finally {
                pHandle.finish();
            }
        }
        if (itemsC == null) {
            return null;
        }
        final ArrayList<I> items = new ArrayList<I>(itemsC);
        if (this.filtersProperties) {
            Iterator itemsIt = items.iterator();
            while (itemsIt.hasNext()) {
                if (this.includeItem(itemsIt.next())) continue;
                itemsIt.remove();
            }
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(items.size(), this.maxPropertyItems){

            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            protected HeapViewerNode createNode(Integer index) {
                return TruffleObjectPropertyProvider.this.createNode(items.get(index), heap);
            }

            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator iterator = 1.integerIterator((int)index, (int)items.size());
                return new ProgressIterator(iterator, index, false, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return TruffleObjectPropertyProvider.this.moreNodesString(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return TruffleObjectPropertyProvider.this.samplesContainerString(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return TruffleObjectPropertyProvider.this.nodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    protected HeapViewerNode[] getNodes(TruffleObjectsWrapper<O> objects, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        return null;
    }

    final O getObject(HeapViewerNode node, Heap heap) {
        if (node == null) {
            return null;
        }
        TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
        if (object == null || !this.objectClass.isInstance(object)) {
            return null;
        }
        return (O)object;
    }

    public static abstract class References<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
    extends TruffleObjectPropertyProvider<O, T, F, L, FieldValue> {
        protected References(String propertyName, L language, boolean filtersProperties) {
            super(propertyName, language, false, filtersProperties, UIThresholds.MAX_INSTANCE_REFERENCES);
        }

        protected abstract HeapViewerNode createObjectReferenceNode(O var1, String var2, FieldValue var3);

        @Override
        protected boolean includeItem(FieldValue field) {
            Instance instance = field.getDefiningInstance();
            if (instance == null) {
                return false;
            }
            if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                return true;
            }
            if (DynamicObject.isDynamicObject(instance)) {
                return true;
            }
            return this.includeInstance(instance);
        }

        protected boolean includeInstance(Instance instance) {
            return true;
        }

        @Override
        protected final HeapViewerNode createNode(FieldValue field, Heap heap) {
            Instance instance = field.getDefiningInstance();
            if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                Object object = ((TruffleLanguage)((Object)this.getLanguage())).createObject(instance);
                return this.createObjectReferenceNode(object, ((TruffleObject)object).getType(), field);
            }
            return this.createForeignReferenceNode(instance, field, heap);
        }

        protected HeapViewerNode createForeignReferenceNode(Instance instance, FieldValue field, Heap heap) {
            if (DynamicObject.isDynamicObject(instance)) {
                DynamicObject dobj = new DynamicObject(instance);
                return new DynamicObjectReferenceNode<DynamicObject>(dobj, dobj.getType(), field);
            }
            return new TerminalJavaNodes.Field((ObjectFieldValue)field, true);
        }

        @Override
        protected String getMergedPropertiesKey() {
            return "HeapViewer.autoMergedReferences";
        }

        @Override
        protected HeapViewerNode[] getNodes(TruffleObjectsWrapper<O> objects, HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            if (this.getMergedPropertiesKey() == null) {
                return null;
            }
            return new TruffleObjectMergedReferences<O>(objects, heap){

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return this.moreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return this.samplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return this.nodesContainerString(firstNodeIdx, lastNodeIdx);
                }

                @Override
                protected TruffleLanguage getLanguage() {
                    return this.getLanguage();
                }

                @Override
                protected boolean filtersReferences() {
                    return this.filtersProperties();
                }

                @Override
                protected boolean includeReference(FieldValue field) {
                    return this.includeItem(field);
                }

                @Override
                protected Collection<FieldValue> getReferences(O object) throws InterruptedException {
                    return this.getPropertyItems(object);
                }

                @Override
                protected HeapViewerNode createForeignReferenceNode(Instance instance, FieldValue field) {
                    return this.createForeignReferenceNode(instance, field, heap);
                }
            }.getNodes(parent, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
    }

    public static abstract class Fields<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
    extends TruffleObjectPropertyProvider<O, T, F, L, FieldValue> {
        protected Fields(String propertyName, L language, boolean filtersProperties) {
            super(propertyName, language, false, filtersProperties, UIThresholds.MAX_INSTANCE_FIELDS);
        }

        protected abstract HeapViewerNode createObjectFieldNode(O var1, String var2, FieldValue var3);

        @Override
        protected boolean includeItem(FieldValue field) {
            if (!(field instanceof ObjectFieldValue)) {
                return true;
            }
            Instance instance = ((ObjectFieldValue)field).getInstance();
            if (instance == null) {
                return true;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                return true;
            }
            if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                return true;
            }
            if (DynamicObject.isDynamicObject(instance)) {
                return true;
            }
            return this.includeInstance(instance);
        }

        protected boolean includeInstance(Instance instance) {
            return true;
        }

        @Override
        protected final HeapViewerNode createNode(FieldValue field, Heap heap) {
            if (field instanceof ObjectFieldValue) {
                Instance instance = ((ObjectFieldValue)field).getInstance();
                if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                    Object object = ((TruffleLanguage)((Object)this.getLanguage())).createObject(instance);
                    return this.createObjectFieldNode(object, ((TruffleObject)object).getType(), field);
                }
                return this.createForeignFieldNode(instance, field, heap);
            }
            return new PrimitiveNode.Field(field);
        }

        protected HeapViewerNode createForeignFieldNode(Instance instance, FieldValue field, Heap heap) {
            if (DynamicObject.isDynamicObject(instance)) {
                DynamicObject dobj = new DynamicObject(instance);
                return new DynamicObjectFieldNode<DynamicObject>(dobj, dobj.getType(), field);
            }
            return new TerminalJavaNodes.Field((ObjectFieldValue)field, false);
        }

        @Override
        protected String getMergedPropertiesKey() {
            return "HeapViewer.autoMergedFields";
        }

        @Override
        protected HeapViewerNode[] getNodes(TruffleObjectsWrapper<O> objects, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            if (this.getMergedPropertiesKey() == null) {
                return null;
            }
            return new TruffleObjectMergedFields<O>(objects, heap){

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return this.moreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return this.samplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return this.nodesContainerString(firstNodeIdx, lastNodeIdx);
                }

                @Override
                protected TruffleLanguage getLanguage() {
                    return this.getLanguage();
                }

                @Override
                protected boolean filtersFields() {
                    return this.filtersProperties();
                }

                @Override
                protected boolean includeField(FieldValue field) {
                    return this.includeItem(field);
                }

                @Override
                protected Collection<FieldValue> getFields(O object) throws InterruptedException {
                    return this.getPropertyItems(object);
                }
            }.getNodes(parent, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
    }
}

